/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.device.IFluxPlug;
import sonar.fluxnetworks.api.device.IFluxPoint;
import sonar.fluxnetworks.api.device.IFluxStorage;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;

public class NetworkStatistics {
    public static final int CHANGE_COUNT = 6;
    private final IFluxNetwork network;
    private int timer;
    public int fluxPlugCount;
    public int fluxPointCount;
    public int fluxControllerCount;
    public int fluxStorageCount;
    public long energyInput;
    public long energyOutput;
    public final LongList energyChange = new LongArrayList(6);
    public long totalBuffer;
    public long totalEnergy;
    private long energyChange5;
    private long energyInput4;
    private long energyOutput4;
    public int averageTickMicro;
    private long runningTotalNano;
    private long startNanoTime;

    public NetworkStatistics(IFluxNetwork network) {
        this.network = network;
        this.energyChange.size(6);
    }

    public void startProfiling() {
        this.startNanoTime = System.nanoTime();
    }

    public void stopProfiling() {
        if (this.timer == 0) {
            this.weakestTick();
        }
        if (this.timer % 5 == 0) {
            this.weakTick();
        }
        if (this.timer % 20 == 0) {
            this.weakerTick();
        }
        this.runningTotalNano += System.nanoTime() - this.startNanoTime;
        ++this.timer;
        this.timer %= 100;
    }

    private void weakTick() {
        List<IFluxPlug> plugs = this.network.getConnections(FluxLogicType.PLUG);
        plugs.forEach(p -> {
            if (!p.getDeviceType().isStorage()) {
                this.energyInput4 += p.getTransferChange();
            }
        });
        List<IFluxPoint> points = this.network.getConnections(FluxLogicType.POINT);
        points.forEach(p -> {
            if (!p.getDeviceType().isStorage()) {
                this.energyOutput4 -= p.getTransferChange();
            }
        });
    }

    private void weakerTick() {
        this.totalBuffer = 0L;
        this.totalEnergy = 0L;
        List<IFluxDevice> devices = this.network.getConnections(FluxLogicType.ANY);
        devices.forEach(p -> {
            if (!p.getDeviceType().isStorage()) {
                this.totalBuffer += p.getTransferBuffer();
            }
        });
        List<IFluxStorage> storages = this.network.getConnections(FluxLogicType.STORAGE);
        storages.forEach(p -> this.totalEnergy += p.getTransferBuffer());
        this.fluxControllerCount = this.network.getConnections(FluxLogicType.CONTROLLER).size();
        this.fluxStorageCount = storages.size();
        this.fluxPlugCount = this.network.getConnections(FluxLogicType.PLUG).size() - this.fluxStorageCount;
        this.fluxPointCount = this.network.getConnections(FluxLogicType.POINT).size() - this.fluxStorageCount - this.fluxControllerCount;
        this.energyInput = this.energyInput4 / 4L;
        this.energyOutput = this.energyOutput4 / 4L;
        this.energyInput4 = 0L;
        this.energyOutput4 = 0L;
        this.energyChange5 += Math.max(this.energyInput, this.energyOutput);
        this.averageTickMicro = (int)Math.min(this.runningTotalNano / 20000L, Integer.MAX_VALUE);
        this.runningTotalNano = 0L;
    }

    private void weakestTick() {
        for (int i = 1; i < 6; ++i) {
            this.energyChange.set(i - 1, this.energyChange.getLong(i));
        }
        this.energyChange.set(5, this.energyChange5 / 5L);
        this.energyChange5 = 0L;
    }

    public int getConnectionCount() {
        return this.fluxPlugCount + this.fluxPointCount + this.fluxStorageCount + this.fluxControllerCount;
    }

    public void writeNBT(CompoundNBT tag) {
        tag.func_74768_a("1", this.fluxPlugCount);
        tag.func_74768_a("2", this.fluxPointCount);
        tag.func_74768_a("3", this.fluxControllerCount);
        tag.func_74768_a("4", this.fluxStorageCount);
        tag.func_74772_a("5", this.energyInput);
        tag.func_74772_a("6", this.energyOutput);
        tag.func_74772_a("7", this.totalBuffer);
        tag.func_74772_a("8", this.totalEnergy);
        tag.func_74768_a("9", this.averageTickMicro);
        tag.func_202168_c("a", (List)this.energyChange);
    }

    public void readNBT(CompoundNBT tag) {
        this.fluxPlugCount = tag.func_74762_e("1");
        this.fluxPointCount = tag.func_74762_e("2");
        this.fluxControllerCount = tag.func_74762_e("3");
        this.fluxStorageCount = tag.func_74762_e("4");
        this.energyInput = tag.func_74763_f("5");
        this.energyOutput = tag.func_74763_f("6");
        this.totalBuffer = tag.func_74763_f("7");
        this.totalEnergy = tag.func_74763_f("8");
        this.averageTickMicro = tag.func_74762_e("9");
        long[] a = tag.func_197645_o("a");
        for (int i = 0; i < a.length; ++i) {
            this.energyChange.set(i, a[i]);
        }
    }
}

