/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.PageLabelButton;
import sonar.fluxnetworks.common.misc.FluxMenu;

public abstract class GuiTabPages<T>
extends GuiTabCore {
    public List<T> elements = Lists.newArrayList();
    protected List<T> current = Lists.newArrayList();
    protected SortType sortType = SortType.ID;
    protected PageLabelButton labelButton;
    private boolean init;
    public int page = 1;
    public int currentPages = 1;
    public int pages = 1;
    public int gridPerPage = 1;
    public int gridStartX = 0;
    public int gridStartY = 0;
    public int gridHeight = 0;
    public int elementHeight = 0;
    public int elementWidth = 0;

    public GuiTabPages(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        int y;
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.pages > 1) {
            this.labelButton.drawButton(this.field_230706_i_, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        int i = 0;
        for (T s : this.current) {
            y = this.gridStartY + this.gridHeight * i;
            this.renderElement(matrixStack, s, this.gridStartX, y);
            ++i;
        }
        i = 0;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)400.0f);
        for (T s : this.current) {
            y = this.gridStartY + this.gridHeight * i;
            if (mouseX >= this.gridStartX + this.field_147003_i && mouseY >= y + this.field_147009_r && mouseX < this.gridStartX + this.elementWidth + this.field_147003_i && mouseY < y + this.elementHeight + this.field_147009_r) {
                this.renderElementTooltip(matrixStack, s, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                break;
            }
            ++i;
        }
        RenderSystem.popMatrix();
    }

    @Override
    protected void drawBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
    }

    @Nullable
    public T getHoveredElement(int mouseX, int mouseY) {
        if (this.current.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.currentPages; ++i) {
            int y = this.gridStartY + this.gridHeight * i;
            if (mouseX < this.gridStartX || mouseY < y || mouseX >= this.gridStartX + this.elementWidth || mouseY >= y + this.elementHeight || this.current.get(i) == null) continue;
            return this.current.get(i);
        }
        return null;
    }

    protected abstract void onElementClicked(T var1, int var2);

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        T e = this.getHoveredElement((int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r);
        if (e != null) {
            this.onElementClicked(e, mouseButton);
            return true;
        }
        if (this.pages > 1 && this.labelButton.isMouseHovered(this.field_230706_i_, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r) && this.page != this.labelButton.hoveredPage) {
            this.page = Math.max(this.labelButton.hoveredPage, 1);
            this.refreshCurrentPage();
            return true;
        }
        return false;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.labelButton = new PageLabelButton(14, 157, this.page, this.pages, this.network.getNetworkColor());
    }

    @Override
    public boolean mouseScrolledMain(double mouseX, double mouseY, double scroll) {
        if (scroll == -1.0 && this.page < this.pages) {
            ++this.page;
            this.refreshCurrentPage();
            return true;
        }
        if (scroll == 1.0 && this.page > 1) {
            --this.page;
            this.refreshCurrentPage();
            return true;
        }
        return super.mouseScrolledMain(mouseX, mouseY, scroll);
    }

    public abstract void renderElement(MatrixStack var1, T var2, int var3, int var4);

    public abstract void renderElementTooltip(MatrixStack var1, T var2, int var3, int var4);

    protected void refreshPages(List<T> elements) {
        this.elements = elements;
        this.pages = (int)Math.ceil((double)elements.size() / (double)this.gridPerPage);
        this.sortGrids(this.sortType);
        if (!this.init) {
            this.refreshCurrentPage();
            this.init = true;
        } else {
            this.refreshCurrentPageInternal();
        }
    }

    protected void refreshCurrentPage() {
        this.refreshCurrentPageInternal();
        this.labelButton.refreshPages(this.page, this.pages);
    }

    protected void refreshCurrentPageInternal() {
        if (this.elements.size() == 0) {
            return;
        }
        this.current.clear();
        int a = (this.page - 1) * this.gridPerPage;
        int b = Math.min(this.elements.size(), this.page * this.gridPerPage);
        this.currentPages = b - a;
        for (int i = a; i < b; ++i) {
            this.current.add(this.elements.get(i));
        }
    }

    protected void sortGrids(SortType sortType) {
    }

    public static enum SortType {
        ID(FluxTranslate.SORTING_ID),
        NAME(FluxTranslate.SORTING_NAME);

        private final FluxTranslate name;

        private SortType(FluxTranslate name) {
            this.name = name;
        }

        public String getTranslatedName() {
            return this.name.t();
        }
    }
}

