/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupHost;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;
import sonar.fluxnetworks.register.NetworkHandler;

public abstract class GuiFluxCore
extends GuiPopupHost {
    public List<List<? extends GuiButtonCore>> buttonLists = Lists.newArrayList();
    protected List<NormalButton> field_230710_m_ = Lists.newArrayList();
    protected List<SlidedSwitchButton> switches = Lists.newArrayList();
    public final PlayerEntity player;
    public IFluxNetwork network;
    public AccessLevel accessLevel = AccessLevel.BLOCKED;
    protected boolean networkValid;

    public GuiFluxCore(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.player = player;
        this.network = FluxClientCache.getNetwork(container.bridge.getNetworkID());
        this.networkValid = this.network.isValid();
        if (FluxClientCache.superAdmin) {
            this.accessLevel = AccessLevel.SUPER_ADMIN;
        } else {
            this.network.getMemberByUUID(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH())).ifPresent(m -> {
                this.accessLevel = m.getAccessLevel();
            });
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.buttonLists.clear();
        this.field_230710_m_.clear();
        this.switches.clear();
        this.buttonLists.add(this.field_230710_m_);
        this.buttonLists.add(this.switches);
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        this.buttonLists.forEach(list -> list.forEach(b -> b.drawButton(this.field_230706_i_, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r)));
    }

    @Override
    protected void drawBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.BACKGROUND);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 128, this.field_230709_l_ / 2 - 128, 0, 0, 256, 256);
        this.screenUtils.setGuiColoring(this.network.getNetworkColor());
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.FRAME);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 128, this.field_230709_l_ / 2 - 128, 0, 0, 256, 256);
        this.buttonLists.forEach(list -> list.forEach(b -> b.updateButton(partialTicks, mouseX, mouseY)));
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        for (List<? extends GuiButtonCore> list : this.buttonLists) {
            for (GuiButtonCore guiButtonCore : list) {
                if (!guiButtonCore.clickable || !guiButtonCore.isMouseHovered(this.field_230706_i_, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                this.onButtonClicked(guiButtonCore, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r, mouseButton);
                return true;
            }
        }
        return super.mouseClickedMain(mouseX, mouseY, mouseButton);
    }

    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.network = FluxClientCache.getNetwork(((FluxMenu)this.field_147002_h).bridge.getNetworkID());
        this.networkValid = this.network.isValid();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        FluxClientCache.setFeedbackText(FeedbackInfo.NONE);
    }

    protected void renderNavigationPrompt(MatrixStack matrixStack, String error, String prompt) {
        this.drawCenterText(matrixStack, error, (float)this.field_146999_f / 2.0f, 16.0f, -8355712);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.625f, 0.625f, 1.0f);
        this.drawCenterText(matrixStack, FluxTranslate.CLICK_ABOVE.format(TextFormatting.AQUA + prompt + TextFormatting.RESET), (float)this.field_146999_f / 2.0f * 1.6f, 41.600002f, 0x808080);
        matrixStack.func_227865_b_();
    }

    protected void renderTransfer(MatrixStack matrixStack, IFluxDevice flux) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.screenUtils.resetGuiColouring();
        this.field_230712_o_.func_238421_b_(matrixStack, FluxUtils.getTransferInfo(flux, EnergyType.FE), 30.0f, 90.0f, 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(matrixStack, (flux.getDeviceType().isStorage() ? FluxTranslate.ENERGY.t() : FluxTranslate.BUFFER.t()) + ": " + TextFormatting.BLUE + EnergyType.storage(flux.getTransferBuffer()), 30.0f, 100.0f, 0xFFFFFF);
        this.screenUtils.renderItemStack(flux.getDisplayStack(), 10, 91);
    }

    protected List<String> getFluxInfo(IFluxDevice flux) {
        ArrayList list = Lists.newArrayList();
        list.add(TextFormatting.BOLD + flux.getCustomName());
        if (flux.isChunkLoaded()) {
            if (flux.isForcedLoading()) {
                list.add(TextFormatting.AQUA + FluxTranslate.FORCED_LOADING.t());
            }
            list.add(FluxUtils.getTransferInfo(flux, EnergyType.FE));
        } else {
            list.add(TextFormatting.RED + FluxTranslate.CHUNK_UNLOADED.t());
        }
        if (flux.getDeviceType().isStorage()) {
            list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + EnergyType.storage(flux.getTransferBuffer()));
        } else {
            list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + EnergyType.storage(flux.getTransferBuffer()));
        }
        list.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getDisableLimit() ? FluxTranslate.UNLIMITED.t() : EnergyType.storage(flux.getRawLimit())));
        list.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getSurgeMode() ? FluxTranslate.SURGE.t() : Integer.valueOf(flux.getRawPriority())));
        list.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + FluxUtils.getDisplayPos(flux.getGlobalPos()));
        list.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + FluxUtils.getDisplayDim(flux.getGlobalPos()));
        return list;
    }

    public void setConnectedNetwork(int networkID, String password) {
        if (((FluxMenu)this.field_147002_h).bridge instanceof TileFluxDevice) {
            NetworkHandler.C2S_SetNetwork(((TileFluxDevice)((FluxMenu)this.field_147002_h).bridge).func_174877_v(), networkID, password);
        } else if (((FluxMenu)this.field_147002_h).bridge instanceof ItemFluxConfigurator.MenuBridge) {
            NetworkHandler.C2S_ConfiguratorNet(networkID, password);
        } else if (((FluxMenu)this.field_147002_h).bridge instanceof ItemAdminConfigurator.MenuBridge) {
            FluxClientCache.adminViewingNetwork = networkID;
        }
    }

    public void onFeedbackAction(@Nonnull FeedbackInfo info) {
    }
}

