/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

@OnlyIn(value=Dist.CLIENT)
public class FluxColorHandler
implements IBlockColor,
IItemColor {
    public static final FluxColorHandler INSTANCE = new FluxColorHandler();

    public int getColor(@Nonnull BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && pos != null && world != null) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileFluxDevice) {
                return ((TileFluxDevice)tile).brColor;
            }
            return EnumNetworkColor.BLUE.getRGB();
        }
        return -1;
    }

    public int getColor(@Nonnull ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            Screen screen;
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null && tag.func_74767_n("FluxColor") && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluxCore) {
                GuiFluxCore gui = (GuiFluxCore)screen;
                return gui.network.getNetworkColor();
            }
            tag = stack.func_179543_a("FluxData");
            if (tag != null) {
                return FluxClientCache.getNetwork(tag.func_74762_e("networkID")).getNetworkColor();
            }
            return 0xB2B2B2;
        }
        return -1;
    }

    public static int colorMultiplierForConfigurator(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            CompoundNBT tag;
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiFluxCore) {
                GuiFluxCore gui = (GuiFluxCore)screen;
                if (((FluxMenu)gui.func_212873_a_()).bridge instanceof ItemFluxConfigurator.MenuBridge) {
                    return gui.network.getNetworkColor();
                }
            }
            if ((tag = stack.func_179543_a("FluxConfig")) != null) {
                return FluxClientCache.getNetwork(tag.func_74762_e("networkID")).getNetworkColor();
            }
            return 0xB2B2B2;
        }
        return -1;
    }
}

