/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.text.FluxTranslate;

public enum AccessLevel {
    OWNER(FluxTranslate.OWNER, 0xFFAA00, TextFormatting.GOLD),
    ADMIN(FluxTranslate.ADMIN, 0x66CC00, TextFormatting.GREEN),
    USER(FluxTranslate.USER, 0x6699FF, TextFormatting.BLUE),
    BLOCKED(FluxTranslate.BLOCKED, 0xA9A9A9, TextFormatting.GRAY),
    SUPER_ADMIN(FluxTranslate.SUPER_ADMIN, 4915330, TextFormatting.DARK_PURPLE);

    private final FluxTranslate localization;
    private final int color;
    private final TextFormatting formatting;

    private AccessLevel(FluxTranslate localization, int color, TextFormatting formatting) {
        this.localization = localization;
        this.color = color;
        this.formatting = formatting;
    }

    @Nonnull
    public String getName() {
        return this.formatting + this.localization.t();
    }

    public int getColor() {
        return this.color;
    }

    public boolean canUse() {
        return this != BLOCKED;
    }

    public boolean canEdit() {
        return this.canUse() && this != USER;
    }

    public boolean canDelete() {
        return this == OWNER || this == SUPER_ADMIN;
    }
}

