/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.misc;

import java.text.NumberFormat;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.common.misc.FluxUtils;

public enum EnergyType {
    FE("Forge Energy", "FE", "FE/t"),
    EU("Energy Units", "EU", "EU/t");

    private final String name;
    private final String storage;
    private final String usage;

    private EnergyType(String name, String storage, String usage) {
        this.name = name;
        this.storage = storage;
        this.usage = usage;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageSuffix() {
        return this.storage;
    }

    public String getUsageSuffix() {
        return this.usage;
    }

    @Nonnull
    public static String usage(long in) {
        return NumberFormat.getInstance().format(in) + " " + EnergyType.FE.usage;
    }

    @Nonnull
    public static String usageCompact(long in) {
        return FluxUtils.compact(in, EnergyType.FE.usage);
    }

    @Nonnull
    public static String storage(long in) {
        return NumberFormat.getInstance().format(in) + " " + EnergyType.FE.storage;
    }

    @Nonnull
    public static String storageCompact(long in) {
        return FluxUtils.compact(in, EnergyType.FE.storage);
    }
}

