/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.misc.EnergyUtils;

public class FluxConfig {
    private static final Client CLIENT_CONFIG;
    private static final ForgeConfigSpec CLIENT_SPEC;
    private static final Common COMMON_CONFIG;
    private static final ForgeConfigSpec COMMON_SPEC;
    private static final Server SERVER_CONFIG;
    private static final ForgeConfigSpec SERVER_SPEC;
    public static boolean enableButtonSound;
    public static boolean enableOneProbeBasicInfo;
    public static boolean enableOneProbeAdvancedInfo;
    public static boolean enableOneProbeSneaking;
    public static boolean enableFluxRecipe;
    public static boolean enableChunkLoading;
    public static boolean enableSuperAdmin;
    public static long defaultLimit;
    public static long basicCapacity;
    public static long basicTransfer;
    public static long herculeanCapacity;
    public static long herculeanTransfer;
    public static long gargantuanCapacity;
    public static long gargantuanTransfer;
    public static int maximumPerPlayer;
    public static int superAdminRequiredPermission;
    public static List<String> blockBlacklistStrings;
    public static List<String> itemBlackListStrings;
    public static boolean enableGuiDebug;

    static void init() {
        if (FMLEnvironment.dist.isClient()) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FluxConfig::reload);
    }

    static void reload(@Nonnull ModConfig.ModConfigEvent event) {
        ForgeConfigSpec spec = event.getConfig().getSpec();
        if (spec == CLIENT_SPEC) {
            FluxConfig.CLIENT_CONFIG.load();
            FluxNetworks.LOGGER.info("CLIENT CONFIG LOADED");
        } else if (spec == COMMON_SPEC) {
            FluxConfig.COMMON_CONFIG.load();
            EnergyUtils.reloadBlacklist();
            FluxNetworks.LOGGER.info("COMMON CONFIG LOADED");
        } else if (spec == SERVER_SPEC) {
            FluxConfig.SERVER_CONFIG.load();
            FluxNetworks.LOGGER.info("SERVER CONFIG LOADED");
        }
    }

    static {
        ForgeConfigSpec.Builder builder;
        if (FMLEnvironment.dist.isClient()) {
            builder = new ForgeConfigSpec.Builder();
            CLIENT_CONFIG = new Client(builder);
            CLIENT_SPEC = builder.build();
        } else {
            CLIENT_CONFIG = null;
            CLIENT_SPEC = null;
        }
        builder = new ForgeConfigSpec.Builder();
        COMMON_CONFIG = new Common(builder);
        COMMON_SPEC = builder.build();
        builder = new ForgeConfigSpec.Builder();
        SERVER_CONFIG = new Server(builder);
        SERVER_SPEC = builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private final ForgeConfigSpec.BooleanValue mEnableButtonSound;
        private final ForgeConfigSpec.BooleanValue mEnableOneProbeBasicInfo;
        private final ForgeConfigSpec.BooleanValue mEnableOneProbeAdvancedInfo;
        private final ForgeConfigSpec.BooleanValue mEnableOneProbeSneaking;
        private final ForgeConfigSpec.BooleanValue mEnableGuiDebug;

        private Client(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("gui");
            this.mEnableButtonSound = builder.comment("Enable navigation buttons sound when pressing it").translation("fluxnetworks.config.enableButtonSound").define("enableButtonSound", true);
            this.mEnableGuiDebug = builder.comment("Internal use only! Keep this to false!").define("enableGuiDebug", false);
            builder.pop();
            builder.push("OneProbe");
            this.mEnableOneProbeBasicInfo = builder.comment("Displays: Network Name, Live Transfer Rate & Internal Buffer").translation("fluxnetworks.config.enableOneProbeBasicInfo").define("enableOneProbeBasicInfo", true);
            this.mEnableOneProbeAdvancedInfo = builder.comment("Displays: Transfer Limit & Priority etc").translation("fluxnetworks.config.enableOneProbeAdvancedInfo").define("enableOneProbeAdvancedInfo", true);
            this.mEnableOneProbeSneaking = builder.comment("Displays Advanced Info when sneaking only").translation("fluxnetworks.config.enableOneProbeSneaking").define("enableOneProbeSneaking", true);
            builder.pop();
        }

        private void load() {
            enableButtonSound = (Boolean)this.mEnableButtonSound.get();
            enableOneProbeBasicInfo = (Boolean)this.mEnableOneProbeBasicInfo.get();
            enableOneProbeAdvancedInfo = (Boolean)this.mEnableOneProbeAdvancedInfo.get();
            enableOneProbeSneaking = (Boolean)this.mEnableOneProbeSneaking.get();
            enableGuiDebug = (Boolean)this.mEnableGuiDebug.get();
        }
    }

    private static class Common {
        private final ForgeConfigSpec.IntValue mMaximumPerPlayer;
        private final ForgeConfigSpec.IntValue mSuperAdminRequiredPermission;
        private final ForgeConfigSpec.BooleanValue mEnableSuperAdmin;
        private final ForgeConfigSpec.BooleanValue mEnableFluxRecipe;
        private final ForgeConfigSpec.BooleanValue mEnableChunkLoading;
        private final ForgeConfigSpec.ConfigValue<List<String>> mBlockBlacklistStrings;
        private final ForgeConfigSpec.ConfigValue<List<String>> mItemBlackListStrings;

        private Common(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("networks");
            this.mMaximumPerPlayer = builder.comment("Maximum networks each player can have. -1 = no limit").translation("fluxnetworks.config.maximumPerPlayer").defineInRange("maximumPerPlayer", 5, -1, Integer.MAX_VALUE);
            this.mEnableSuperAdmin = builder.comment("Allows someone to be a network super admin, otherwise, no one can access or dismantle your flux devices or delete your networks without permission").translation("fluxnetworks.config.enableSuperAdmin").define("enableSuperAdmin", true);
            this.mSuperAdminRequiredPermission = builder.comment("See ops.json. If the player has permission level equal or greater to the value set here they will be able to Activate Super Admin. Setting this to 0 will allow anyone to active Super Admin.").translation("fluxnetworks.config.superAdminRequiredPermission").defineInRange("superAdminRequiredPermission", 1, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("general");
            this.mEnableFluxRecipe = builder.comment("Enables redstone being compressed with the bedrock and obsidian to get flux").translation("fluxnetworks.config.enableFluxRecipe").define("enableFluxRecipe", true);
            this.mEnableChunkLoading = builder.comment("Allows flux tiles to work as chunk loaders").translation("fluxnetworks.config.enableChunkLoading").define("enableChunkLoading", true);
            builder.pop();
            builder.push("blacklist");
            this.mBlockBlacklistStrings = builder.comment("A blacklist for blocks which flux devices shouldn't connect to, use format 'modid:registry_name'").translation("fluxnetworks.config.blockBlacklistStrings").define("blockBlacklistStrings", (Object)Lists.newArrayList((Object[])new String[]{"actuallyadditions:block_phantom_energyface"}));
            this.mItemBlackListStrings = builder.comment("A blacklist for items which wireless charging shouldn't charge to, use format 'modid:registry_name'").translation("fluxnetworks.config.itemBlackListStrings").define("itemBlackListStrings", (Object)Lists.newArrayList((Object[])new String[]{""}));
            builder.pop();
        }

        private void load() {
            maximumPerPlayer = (Integer)this.mMaximumPerPlayer.get();
            superAdminRequiredPermission = (Integer)this.mSuperAdminRequiredPermission.get();
            enableSuperAdmin = (Boolean)this.mEnableSuperAdmin.get();
            enableFluxRecipe = (Boolean)this.mEnableFluxRecipe.get();
            enableChunkLoading = (Boolean)this.mEnableChunkLoading.get();
            blockBlacklistStrings = (List)this.mBlockBlacklistStrings.get();
            itemBlackListStrings = (List)this.mItemBlackListStrings.get();
        }
    }

    private static class Server {
        private final ForgeConfigSpec.LongValue mDefaultLimit;
        private final ForgeConfigSpec.LongValue mBasicCapacity;
        private final ForgeConfigSpec.LongValue mBasicTransfer;
        private final ForgeConfigSpec.LongValue mHerculeanCapacity;
        private final ForgeConfigSpec.LongValue mHerculeanTransfer;
        private final ForgeConfigSpec.LongValue mGargantuanCapacity;
        private final ForgeConfigSpec.LongValue mGargantuanTransfer;

        private Server(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("energy");
            this.mDefaultLimit = builder.comment("The default transfer limit of a flux connector").translation("fluxnetworks.config.defaultLimit").defineInRange("defaultLimit", 800000L, 0L, Long.MAX_VALUE);
            this.mBasicCapacity = builder.translation("fluxnetworks.config.basicCapacity").defineInRange("basicCapacity", 1000000L, 0L, Long.MAX_VALUE);
            this.mBasicTransfer = builder.translation("fluxnetworks.config.basicTransfer").defineInRange("basicTransfer", 20000L, 0L, Long.MAX_VALUE);
            this.mHerculeanCapacity = builder.translation("fluxnetworks.config.herculeanCapacity").defineInRange("herculeanCapacity", 8000000L, 0L, Long.MAX_VALUE);
            this.mHerculeanTransfer = builder.translation("fluxnetworks.config.herculeanTransfer").defineInRange("herculeanTransfer", 120000L, 0L, Long.MAX_VALUE);
            this.mGargantuanCapacity = builder.translation("fluxnetworks.config.gargantuanCapacity").defineInRange("gargantuanCapacity", 128000000L, 0L, Long.MAX_VALUE);
            this.mGargantuanTransfer = builder.translation("fluxnetworks.config.gargantuanTransfer").defineInRange("gargantuanTransfer", 1440000L, 0L, Long.MAX_VALUE);
            builder.pop();
        }

        private void load() {
            defaultLimit = (Long)this.mDefaultLimit.get();
            basicCapacity = (Long)this.mBasicCapacity.get();
            basicTransfer = (Long)this.mBasicTransfer.get();
            herculeanCapacity = (Long)this.mHerculeanCapacity.get();
            herculeanTransfer = (Long)this.mHerculeanTransfer.get();
            gargantuanCapacity = (Long)this.mGargantuanCapacity.get();
            gargantuanTransfer = (Long)this.mGargantuanTransfer.get();
        }
    }
}

