/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.botanicalmachinery.BotanicalMachinery;
import de.melanx.botanicalmachinery.ModBlocks;
import de.melanx.botanicalmachinery.ModItems;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class ManaInfusionProvider
extends RecipeProvider {
    public ManaInfusionProvider(DataGenerator gen) {
        super(gen);
    }

    @Nonnull
    public String func_200397_b() {
        return "Botanical Machinery mana pool recipes";
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> consumer) {
        ManaInfusionProvider.registerInfusionRecipe(consumer, (IItemProvider)ModItems.manaEmerald, Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD), 8000);
        ManaInfusionProvider.registerInfusionRecipe(consumer, (IItemProvider)ModBlocks.manaEmeraldBlock, Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_EMERALD), 72000);
    }

    private static ResourceLocation id(String s) {
        return new ResourceLocation(BotanicalMachinery.getInstance().modid, "mana_infusion/" + s);
    }

    private static void registerInfusionRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider output, Ingredient input, int mana) {
        String name = output.func_199767_j().getRegistryName().func_110623_a();
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id(name), new ItemStack(output), input, mana));
    }

    private static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final int mana;
        private final String group;
        @Nullable
        private final BlockState catalyst;

        public static FinishedRecipe conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", vazkii.botania.common.block.ModBlocks.conjurationCatalyst.func_176223_P());
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return FinishedRecipe.alchemy(id, output, input, mana, "");
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            return new FinishedRecipe(id, output, input, mana, group, vazkii.botania.common.block.ModBlocks.alchemyCatalyst.func_176223_P());
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            this(id, output, input, mana, "");
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            this(id, output, input, mana, group, null);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group, @Nullable BlockState catalyst) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.catalyst = catalyst;
        }

        public void func_218610_a(JsonObject json) {
            json.add("input", this.input.func_200304_c());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack((ItemStack)this.output));
            json.addProperty("mana", (Number)this.mana);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.catalyst != null) {
                json.add("catalyst", (JsonElement)StateIngredientHelper.serializeBlockState((BlockState)this.catalyst));
            }
        }

        private static <T extends Comparable<T>> String getName(Property<T> prop, Comparable<?> val) {
            return prop.func_177702_a(val);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

