/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.blocks.base.IWorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import de.melanx.botanicalmachinery.helper.RecipeHelper2;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;

public class TileMechanicalBrewery
extends BotanicalTile
implements IWorkingTile {
    public static final int MAX_MANA_PER_TICK = 50;
    public static final List<Item> BREW_CONTAINER = Arrays.asList(ModItems.vial.func_199767_j(), ModItems.flask.func_199767_j(), ModItems.incenseStick.func_199767_j(), ModItems.bloodPendant.func_199767_j());
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(8, slot -> {
        this.update = true;
        this.markDispatchable();
    }, this::isValidStack);
    private IBrewRecipe recipe = null;
    private int progress;
    private int maxProgress = -1;
    private boolean update;
    private ItemStack currentOutput = ItemStack.field_190927_a;

    public TileMechanicalBrewery(TileEntityType<?> type) {
        super(type, LibXServerConfig.MaxManaCapacity.mechanicalBrewery);
        this.inventory.setInputSlots(IntStream.range(0, 7).toArray());
        this.inventory.setOutputSlots(new int[]{7});
        this.update = true;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isValidStack(int slot, ItemStack stack) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (slot == 0) {
            return stack.func_77978_p() != null ? !stack.func_77978_p().func_74764_b("brewKey") : BREW_CONTAINER.contains(stack.func_77973_b());
        }
        return Arrays.stream(this.inventory.getInputSlots()).noneMatch(x -> x == slot) || RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), (IRecipeType)ModRecipeTypes.BREW_TYPE, (ItemStack)stack);
    }

    private void updateRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                this.recipe = null;
                return;
            }
            ArrayList stacks = new ArrayList(this.inventory.getStacks());
            RecipeHelper2.removeFromList(stacks, new int[][]{{0, 7}});
            for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                if (!(recipe instanceof IBrewRecipe) || !RecipeHelper.matches((IRecipe)recipe, stacks, (boolean)false)) continue;
                this.recipe = (IBrewRecipe)recipe;
                this.currentOutput = !(this.inventory.getStackInSlot(0).func_77973_b() instanceof IBrewContainer) ? ItemStack.field_190927_a : ((IBrewContainer)this.inventory.getStackInSlot(0).func_77973_b()).getItemForBrew(this.recipe.getBrew(), this.inventory.getStackInSlot(0).func_77946_l());
                this.markDispatchable();
                return;
            }
        }
        this.currentOutput = ItemStack.field_190927_a;
        this.recipe = null;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.update) {
                this.updateRecipe();
                this.func_70296_d();
                this.update = false;
            }
            if (this.recipe != null) {
                ItemStack output = this.recipe.getOutput(this.inventory.getStackInSlot(0)).func_77946_l();
                ItemStack currentOutput = this.inventory.getStackInSlot(7);
                if (!output.func_190926_b() && (currentOutput.func_190926_b() || ItemStack.func_179545_c((ItemStack)output, (ItemStack)currentOutput) && ItemStack.func_77970_a((ItemStack)output, (ItemStack)currentOutput) && currentOutput.func_190916_E() + output.func_190916_E() <= currentOutput.func_77976_d())) {
                    this.maxProgress = this.getManaCost();
                    int manaTransfer = Math.min(this.getCurrentMana(), Math.min(50, this.getMaxProgress() - this.progress));
                    this.progress += manaTransfer;
                    this.receiveMana(-manaTransfer);
                    if (this.progress >= this.getMaxProgress() && !this.inventory.getStackInSlot(0).func_190926_b()) {
                        if (currentOutput.func_190926_b()) {
                            this.inventory.setStackInSlot(7, output);
                        } else {
                            currentOutput.func_190920_e(currentOutput.func_190916_E() + output.func_190916_E());
                        }
                        this.inventory.getStackInSlot(0).func_190918_g(1);
                        block0: for (Ingredient ingredient : this.recipe.func_192400_c()) {
                            for (int slot : this.inventory.getInputSlots()) {
                                ItemStack stack = this.inventory.getStackInSlot(slot);
                                if (!ingredient.test(stack)) continue;
                                stack.func_190918_g(1);
                                continue block0;
                            }
                        }
                        this.update = true;
                        this.recipe = null;
                        this.progress = 0;
                        this.maxProgress = -1;
                    }
                    this.func_70296_d();
                    this.markDispatchable();
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                this.maxProgress = -1;
                this.func_70296_d();
                this.markDispatchable();
            }
        } else if (this.field_145850_b != null && this.progress > 0 && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.mechanicalBrewery && this.currentOutput.func_77973_b() instanceof IBrewItem && this.field_145850_b.field_73012_v.nextFloat() < 0.5f) {
            int segments = 3;
            for (int i = 1; i <= 6; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ++segments;
            }
            if ((double)this.progress < (double)(segments - 1) * ((double)this.maxProgress / (double)segments) && (double)this.progress > (double)(segments - 2) * ((double)this.maxProgress / (double)segments)) {
                int targetColor = ((IBrewItem)this.currentOutput.func_77973_b()).getBrew(this.currentOutput).getColor(this.currentOutput);
                float red = (float)(targetColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(targetColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(targetColor & 0xFF) / 255.0f;
                WispParticleData data = WispParticleData.wisp((float)0.125f, (float)red, (float)green, (float)blue, (float)0.5f);
                double xPos = (double)this.field_174879_c.func_177958_n() + 0.25 + this.field_145850_b.field_73012_v.nextDouble() / 2.0;
                double zPos = (double)this.field_174879_c.func_177952_p() + 0.25 + this.field_145850_b.field_73012_v.nextDouble() / 2.0;
                this.field_145850_b.func_195594_a((IParticleData)data, xPos, (double)this.field_174879_c.func_177956_o() + 0.35, zPos, 0.0, 0.01 + this.field_145850_b.field_73012_v.nextDouble() / 18.0, 0.0);
            }
        }
    }

    @Override
    public boolean hasValidRecipe() {
        return true;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getMaxManaPerTick() {
        return 50 / LibXServerConfig.WorkingDurationMultiplier.mechanicalBrewery;
    }

    public int getManaCost() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (this.recipe == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof IBrewContainer)) {
            return 0;
        }
        IBrewContainer container = (IBrewContainer)stack.func_77973_b();
        return container.getManaCost(this.recipe.getBrew(), stack);
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Override
    public int getComparatorOutput() {
        return this.getProgress() > 0 ? 15 : 0;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.maxProgress = cmp.func_74762_e("maxProgress");
        this.currentOutput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT cmp) {
        cmp.func_74768_a("progress", this.progress);
        cmp.func_74768_a("maxProgress", this.maxProgress);
        cmp.func_218657_a("currentOutput", (INBT)this.currentOutput.serializeNBT());
        return super.func_189515_b(cmp);
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        this.progress = cmp.func_74762_e("progress");
        this.maxProgress = cmp.func_74762_e("maxProgress");
        this.currentOutput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentOutput"));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_74768_a("progress", this.progress);
        cmp.func_74768_a("maxProgress", this.maxProgress);
        cmp.func_218657_a("currentOutput", (INBT)this.currentOutput.serializeNBT());
        return cmp;
    }
}

