/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import de.melanx.botanicalmachinery.helper.RecipeHelper2;
import io.github.noeppi_noeppi.libx.crafting.recipe.RecipeHelper;
import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileMechanicalApothecary
extends TileEntityBase
implements ITickableTileEntity {
    public static final int WORKING_DURATION = 20;
    public static final int FLUID_CAPACITY = 8000;
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(21, slot -> {
        this.update = true;
        this.markDispatchable();
    }, this::isValidStack);
    private final LazyOptional<IItemHandlerModifiable> handler = ItemStackHandlerWrapper.createLazy(this::getInventory);
    private final ApothecaryFluidTank fluidInventory = new ApothecaryFluidTank(8000, fluidStack -> Fluids.field_204546_a.func_207187_a(fluidStack.getFluid()));
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluidInventory);
    private IPetalRecipe recipe = null;
    private int progress;
    private boolean update;
    private ItemStack currentOutput = ItemStack.field_190927_a;

    public TileMechanicalApothecary(TileEntityType<?> type) {
        super(type);
        this.inventory.setInputSlots(IntStream.range(1, 17).toArray());
        this.inventory.setOutputSlots(IntStream.range(17, 21).toArray());
        this.update = true;
    }

    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    public FluidTank getFluidInventory() {
        return this.fluidInventory;
    }

    public boolean isValidStack(int slot, ItemStack stack) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (slot == 0) {
            return Tags.Items.SEEDS.func_230235_a_((Object)stack.func_77973_b());
        }
        if (Arrays.stream(this.inventory.getInputSlots()).anyMatch(x -> x == slot)) {
            return RecipeHelper.isItemValidInput((RecipeManager)this.field_145850_b.func_199532_z(), (IRecipeType)ModRecipeTypes.PETAL_TYPE, (ItemStack)stack);
        }
        return true;
    }

    private void updateRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ArrayList stacks = new ArrayList(this.inventory.getStacks());
            RecipeHelper2.removeFromList(stacks, IntStream.range(17, stacks.size() - 1).toArray(), {0});
            for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                if (!(recipe instanceof IPetalRecipe) || !RecipeHelper.matches((IRecipe)recipe, stacks, (boolean)false) || this.inventory.getStackInSlot(0).func_190926_b() || this.fluidInventory.getFluidAmount() < 1000) continue;
                this.recipe = (IPetalRecipe)recipe;
                this.currentOutput = this.recipe.func_77571_b().func_77946_l();
                this.markDispatchable();
                return;
            }
        }
        this.currentOutput = ItemStack.field_190927_a;
        this.recipe = null;
    }

    public void func_73660_a() {
        block13: {
            block11: {
                block12: {
                    if (this.field_145850_b == null || this.field_145850_b.field_72995_K) break block11;
                    if (this.update) {
                        this.updateRecipe();
                        this.func_70296_d();
                        this.update = false;
                    }
                    if (this.recipe == null) break block12;
                    if (this.progress <= TileMechanicalApothecary.getRecipeDuration()) {
                        ++this.progress;
                        if (this.progress >= TileMechanicalApothecary.getRecipeDuration()) {
                            ItemStack output = this.recipe.func_77571_b().func_77946_l();
                            block0: for (Ingredient ingredient : this.recipe.func_192400_c()) {
                                for (int slot : this.inventory.getInputSlots()) {
                                    ItemStack stack = this.inventory.getStackInSlot(slot);
                                    if (!ingredient.test(stack)) continue;
                                    stack.func_190918_g(1);
                                    continue block0;
                                }
                            }
                            FluidStack fluid = this.fluidInventory.getFluid();
                            fluid.shrink(1000);
                            this.fluidInventory.setFluid(fluid);
                            this.inventory.getStackInSlot(0).func_190918_g(1);
                            this.putIntoOutput(output);
                            this.update = true;
                            this.recipe = null;
                            this.progress = 0;
                        }
                        this.func_70296_d();
                        this.markDispatchable();
                    }
                    break block13;
                }
                if (this.progress <= 0) break block13;
                this.progress = 0;
                this.func_70296_d();
                this.markDispatchable();
                break block13;
            }
            if (this.field_145850_b != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.mechanicalApothecary && this.fluidInventory.getFluidAmount() > 0) {
                if (this.progress > TileMechanicalApothecary.getRecipeDuration() - 5) {
                    for (int i = 0; i < 5; ++i) {
                        SparkleParticleData data = SparkleParticleData.sparkle((float)this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145850_b.field_73012_v.nextFloat(), (int)10);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModSounds.altarCraft, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                } else {
                    for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                        ItemStack stack = this.inventory.getStackInSlot(slot);
                        if (stack.func_190926_b() || !(this.field_145850_b.field_73012_v.nextFloat() >= 0.97f)) continue;
                        int color = stack.func_77973_b() instanceof ICustomApothecaryColor ? ((ICustomApothecaryColor)stack.func_77973_b()).getParticleColor(stack) : 0x888888;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        if (Math.random() >= 0.75) {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
                        }
                        SparkleParticleData data = SparkleParticleData.sparkle((float)this.field_145850_b.field_73012_v.nextFloat(), (float)red, (float)green, (float)blue, (int)10);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    private void putIntoOutput(ItemStack stack) {
        for (int i : this.inventory.getOutputSlots()) {
            if (stack.func_190926_b()) break;
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                this.inventory.getUnrestricted().insertItem(i, stack.func_77946_l(), false);
                break;
            }
            if (slotStack.func_77973_b() != stack.func_77973_b() || slotStack.func_190916_E() >= slotStack.func_77976_d()) continue;
            ItemStack left = this.inventory.getUnrestricted().insertItem(i, stack, false);
            if (left == ItemStack.field_190927_a) break;
            stack = left;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public static int getRecipeDuration() {
        return 20 * LibXServerConfig.WorkingDurationMultiplier.mechanicalApothecary;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    @Nonnull
    public <X> LazyOptional<X> getCapability(@Nonnull Capability<X> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT cmp) {
        super.func_230337_a_(state, cmp);
        this.getInventory().deserializeNBT(cmp.func_74775_l("inv"));
        this.fluidInventory.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)cmp.func_74775_l("fluid")));
        this.progress = cmp.func_74762_e("progress");
        this.currentOutput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentOutput"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT cmp) {
        cmp.func_218657_a("inv", (INBT)this.getInventory().serializeNBT());
        CompoundNBT tankTag = new CompoundNBT();
        this.getFluidInventory().getFluid().writeToNBT(tankTag);
        cmp.func_218657_a("fluid", (INBT)tankTag);
        cmp.func_74768_a("progress", this.progress);
        cmp.func_218657_a("currentOutput", (INBT)this.currentOutput.serializeNBT());
        return super.func_189515_b(cmp);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT cmp) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return;
        }
        super.handleUpdateTag(state, cmp);
        this.getInventory().deserializeNBT(cmp.func_74775_l("inv"));
        this.fluidInventory.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)cmp.func_74775_l("fluid")));
        this.progress = cmp.func_74762_e("progress");
        this.currentOutput = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("currentOutput"));
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT cmp = super.func_189517_E_();
        cmp.func_218657_a("inv", (INBT)this.getInventory().serializeNBT());
        CompoundNBT tankTag = new CompoundNBT();
        this.getFluidInventory().getFluid().writeToNBT(tankTag);
        cmp.func_218657_a("fluid", (INBT)tankTag);
        cmp.func_74768_a("progress", this.progress);
        cmp.func_218657_a("currentOutput", (INBT)this.currentOutput.serializeNBT());
        return cmp;
    }

    private class ApothecaryFluidTank
    extends FluidTank {
        public ApothecaryFluidTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            TileMechanicalApothecary.this.markDispatchable();
            TileMechanicalApothecary.this.update = true;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

