/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.melanx.botanicalmachinery.blocks.tiles.TileMechanicalRunicAltar;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import io.github.noeppi_noeppi.libx.block.tesr.HorizontalRotatedTesr;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class TesrMechanicalRunicAltar
extends HorizontalRotatedTesr<TileMechanicalRunicAltar> {
    private final ModelRenderer spinningCube = new ModelRenderer(64, 32, 42, 0);

    public TesrMechanicalRunicAltar(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    protected void doRender(@Nonnull TileMechanicalRunicAltar tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalRunicAltar) {
            return;
        }
        ItemStack livingRockStack = tile.getInventory().getStackInSlot(0);
        if (!livingRockStack.func_190926_b() && livingRockStack.func_77973_b() instanceof BlockItem) {
            BlockState state = ((BlockItem)livingRockStack.func_77973_b()).func_179223_d().func_176223_P();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
            matrixStack.func_227861_a_(6.5, 10.0, 6.5);
            matrixStack.func_227862_a_(3.0f, 3.0f, 3.0f);
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-((float)ClientTickHandler.ticksInGame + partialTicks)));
            matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
            Minecraft.func_71410_x().func_175602_ab().func_228791_a_(state, matrixStack, buffer, 200, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        double progressLeft = 1.0 - (double)tile.getProgress() / (double)tile.getMaxProgress() * 0.9;
        int items = 0;
        for (int slot : tile.getInventory().getInputSlots()) {
            if (tile.getInventory().getStackInSlot(slot).func_190926_b()) continue;
            ++items;
        }
        float[] angles = new float[items];
        float anglePer = 360.0f / (float)items;
        float totalAngle = 0.0f;
        for (int i = 0; i < angles.length; ++i) {
            angles[i] = totalAngle += anglePer;
        }
        float time = (float)ClientTickHandler.ticksInGame + partialTicks;
        int nextAngleIdx = 0;
        for (int slot : tile.getInventory().getInputSlots()) {
            if (tile.getInventory().getStackInSlot(slot).func_190926_b()) continue;
            double travelCenter = 1.0;
            boolean shrink = false;
            if (tile.isSlotUsedCurrently(slot)) {
                travelCenter = progressLeft;
            } else if (tile.getProgress() > 0) {
                shrink = true;
            }
            int angleIdx = nextAngleIdx++;
            if (angleIdx >= angles.length) break;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.675, 0.5);
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angles[angleIdx] + time));
            matrixStack.func_227861_a_(travelCenter * 1.125, 0.0, travelCenter * 0.25);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, 0.075 * Math.sin((double)(time + (float)(angleIdx * 10)) / 5.0), 0.0);
            if (shrink) {
                matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            }
            ItemStack stack = tile.getInventory().getStackInSlot(slot);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, 200, OverlayTexture.field_229196_a_, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
    }
}

