/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeCrafter.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TooltipBuilder {
    List<ITextComponent> tooltip = new ArrayList<ITextComponent>();

    public TooltipBuilder addTip(String text) {
        this.tooltip.add((ITextComponent)new StringTextComponent(text));
        return this;
    }

    public TooltipBuilder addTip(String text, TextFormatting formatting) {
        this.tooltip.add((ITextComponent)new StringTextComponent(formatting + text));
        return this;
    }

    public TooltipBuilder addTranslatableTip(String key, TextFormatting formatting) {
        this.tooltip.add((ITextComponent)new TranslationTextComponent(key).func_240699_a_(formatting));
        return this;
    }

    public TooltipBuilder addTranslatableTip(String key) {
        this.tooltip.add((ITextComponent)new TranslationTextComponent(key));
        return this;
    }

    public TooltipBuilder applyStyle(TextFormatting formatting) {
        StringTextComponent textComponent = new StringTextComponent(formatting + this.tooltip.remove(this.tooltip.size() - 1).getString());
        this.tooltip.add((ITextComponent)textComponent);
        return this;
    }

    public TooltipBuilder appendText(String text) {
        IFormattableTextComponent textComponent = (IFormattableTextComponent)this.tooltip.remove(this.tooltip.size() - 1);
        textComponent.func_240702_b_(text);
        this.tooltip.add((ITextComponent)textComponent);
        return this;
    }

    public TooltipBuilder appendText(String text, TextFormatting formatting) {
        IFormattableTextComponent textComponent = (IFormattableTextComponent)this.tooltip.remove(this.tooltip.size() - 1);
        textComponent.func_240702_b_(formatting + text);
        this.tooltip.add((ITextComponent)textComponent);
        return this;
    }

    public List<ITextComponent> build() {
        return this.tooltip.isEmpty() ? null : this.tooltip;
    }
}

