/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredExporterTileEntity;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TieredExporterNetworkNode
extends TieredNetworkNode<TieredExporterNetworkNode>
implements IComparable,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 9;
    private static final int SPEED_INCREASE = 2;
    private final BaseItemHandler itemFilters;
    private final FluidInventory fluidFilters;
    private final UpgradeItemHandler upgrades;
    private int compare = 1;
    private int type = 0;
    private int filterSlot;
    private final CoverManager coverManager = new CoverManager((NetworkNode)this);

    public TieredExporterNetworkNode(World world, BlockPos pos, CableTier tier) {
        super(world, pos, ContentType.EXPORTER, tier);
        this.itemFilters = new BaseItemHandler(9 * tier.getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
        this.fluidFilters = new FluidInventory(9 * tier.getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
        this.upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.CheckTierUpgrade()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
            if (!reading && !this.getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                int i;
                boolean changed = false;
                for (i = 0; i < this.itemFilters.getSlots(); ++i) {
                    ItemStack filteredItem = this.itemFilters.getStackInSlot(i);
                    if (filteredItem.func_190916_E() <= 1) continue;
                    filteredItem.func_190920_e(1);
                    changed = true;
                }
                for (i = 0; i < this.fluidFilters.getSlots(); ++i) {
                    FluidStack filteredFluid = this.fluidFilters.getFluid(i);
                    if (filteredFluid.isEmpty() || filteredFluid.getAmount() == 1000) continue;
                    filteredFluid.setAmount(1000);
                    changed = true;
                }
                if (changed) {
                    this.markDirty();
                }
            }
        });
    }

    private UpgradeItem.Type[] CheckTierUpgrade() {
        if (this.getTier() == CableTier.ELITE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.REGULATOR};
        }
        if (this.getTier() == CableTier.ULTRA) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.REGULATOR};
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.CRAFTING, UpgradeItem.Type.REGULATOR};
        }
        return null;
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    private int getSpeedMultiplier() {
        switch (this.getTier()) {
            case ELITE: {
                return (Integer)CableConfig.ELITE_EXPORTER_SPEED.get();
            }
            case ULTRA: {
                return (Integer)CableConfig.ULTRA_EXPORTER_SPEED.get();
            }
        }
        throw new RuntimeException("illegal tier " + (Object)((Object)this.getTier()));
    }

    private boolean interactWithStacks() {
        return this.getTier() != CableTier.ELITE || this.upgrades.hasUpgrade(UpgradeItem.Type.STACK);
    }

    private int getInteractionSize(ItemStack stack) {
        return this.interactWithStacks() ? stack.func_77976_d() : 1;
    }

    public void update() {
        int baseSpeed;
        int speed;
        super.update();
        if (!(this.canUpdate() && this.world.func_195588_v(this.pos) && this.world.func_195588_v(this.pos.func_177972_a(this.getDirection())))) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && (speed = Math.max(1, this.upgrades.getSpeed(baseSpeed = 9 / this.getSpeedMultiplier(), 2))) > 1 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            this.itemUpdate();
        } else if (this.type == 1) {
            this.fluidUpdate();
        }
    }

    private void itemUpdate() {
        IItemHandler handler = WorldUtils.getItemHandler((TileEntity)this.getFacingTile(), (Direction)this.getDirection().func_176734_d());
        if (handler == null || handler.getSlots() <= 0) {
            return;
        }
        if (this.filterSlot >= this.itemFilters.getSlots()) {
            this.filterSlot = 0;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            while (this.doItemInsertion(handler)) {
            }
        } else {
            this.doItemInsertion(handler);
        }
    }

    private boolean doItemInsertion(IItemHandler handler) {
        int startSlot = this.filterSlot;
        do {
            boolean work = false;
            ItemStack filter = this.itemFilters.getStackInSlot(this.filterSlot);
            if (!filter.func_190926_b()) {
                int toTransfer;
                int interactionCount;
                int n = interactionCount = this.interactWithStacks() ? filter.func_77976_d() : 1;
                if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                    int requested = 0;
                    for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
                        ItemStack otherFilter = this.itemFilters.getStackInSlot(i);
                        if (!API.instance().getComparer().isEqual(filter, otherFilter, this.compare)) continue;
                        requested += otherFilter.func_190916_E();
                    }
                    int actual = 0;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (!API.instance().getComparer().isEqual(filter, stack, this.compare)) continue;
                        actual += stack.func_190916_E();
                    }
                    int needed = Math.max(0, requested - actual);
                    toTransfer = Math.min(interactionCount, needed);
                } else {
                    toTransfer = interactionCount;
                }
                if (toTransfer > 0) {
                    int inserted;
                    int remaining;
                    ItemStack extracted = this.network.extractItem(filter, toTransfer, this.compare, Action.SIMULATE);
                    if (extracted.func_190926_b()) {
                        if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                            this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, this.filterSlot), filter, toTransfer);
                            work = false;
                        }
                    } else if (this.getTier() == CableTier.ELITE) {
                        remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)true).func_190916_E();
                        inserted = extracted.func_190916_E() - remaining;
                        if (inserted > 0) {
                            extracted = this.network.extractItem(filter, inserted, this.compare, Action.PERFORM);
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
                            work = true;
                        }
                    } else {
                        remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extracted, (boolean)true).func_190916_E();
                        inserted = extracted.func_190916_E() - remaining;
                        if (inserted > 0) {
                            extracted = this.network.extractItem(filter, inserted, this.compare, Action.PERFORM);
                            ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
                            work = true;
                        }
                    }
                }
            }
            if (++this.filterSlot >= this.itemFilters.getSlots()) {
                this.filterSlot = 0;
            }
            if (!work) continue;
            return true;
        } while (this.filterSlot != startSlot);
        return false;
    }

    private void fluidUpdate() {
        IFluidHandler handler = WorldUtils.getFluidHandler((TileEntity)this.getFacingTile(), (Direction)this.getDirection().func_176734_d());
        if (handler == null || handler.getTanks() <= 0) {
            return;
        }
        if (this.filterSlot >= this.fluidFilters.getSlots()) {
            this.filterSlot = 0;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            while (this.doFluidInsertion(handler)) {
            }
        } else {
            this.doFluidInsertion(handler);
        }
    }

    private boolean doFluidInsertion(IFluidHandler handler) {
        int startSlot = this.filterSlot;
        do {
            boolean work = false;
            FluidStack filter = this.fluidFilters.getFluid(this.filterSlot);
            if (!filter.isEmpty()) {
                int toTransfer;
                int interactionCount;
                int n = this.interactWithStacks() ? (this.getTier() == CableTier.CREATIVE ? Integer.MAX_VALUE : 64000) : (interactionCount = 1000);
                if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                    int requested = 0;
                    for (int i = 0; i < this.fluidFilters.getSlots(); ++i) {
                        FluidStack otherFilter = this.fluidFilters.getFluid(i);
                        if (!API.instance().getComparer().isEqual(filter, otherFilter, this.compare)) continue;
                        requested += otherFilter.getAmount();
                    }
                    int actual = 0;
                    for (int i = 0; i < handler.getTanks(); ++i) {
                        FluidStack stack = handler.getFluidInTank(i);
                        if (!API.instance().getComparer().isEqual(filter, stack, this.compare)) continue;
                        actual += stack.getAmount();
                    }
                    int needed = Math.max(0, requested - actual);
                    toTransfer = Math.min(interactionCount, needed);
                } else {
                    toTransfer = interactionCount;
                }
                if (toTransfer > 0) {
                    FluidStack extracted = this.network.extractFluid(filter, toTransfer, this.compare, Action.SIMULATE);
                    if (extracted.isEmpty()) {
                        if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                            this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, this.filterSlot), filter, toTransfer);
                            work = false;
                        }
                    } else {
                        int inserted = handler.fill(extracted, IFluidHandler.FluidAction.SIMULATE);
                        if (inserted > 0) {
                            extracted = this.network.extractFluid(filter, inserted, this.compare, Action.PERFORM);
                            handler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                            work = true;
                        }
                    }
                }
            }
            if (++this.filterSlot >= this.fluidFilters.getSlots()) {
                this.filterSlot = 0;
            }
            if (!work) continue;
            return true;
        } while (this.filterSlot != startSlot);
        return false;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TieredExporterTileEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

