/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.init;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.gui.TieredConstructorScreen;
import com.YTrollman.CableTiers.gui.TieredDestructorScreen;
import com.YTrollman.CableTiers.gui.TieredDiskManipulatorScreen;
import com.YTrollman.CableTiers.gui.TieredExporterScreen;
import com.YTrollman.CableTiers.gui.TieredImporterScreen;
import com.YTrollman.CableTiers.gui.TieredRequesterScreen;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.BakedModelCableCover;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEventHandler {
    private static final BakedModelOverrideRegistry bakedModelOverrideRegistry = new BakedModelOverrideRegistry();

    public ClientEventHandler() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    public void init(FMLClientSetupEvent event) {
        for (CableTier tier : CableTier.VALUES) {
            for (ContentType<?, ?, ?, ?> type : ContentType.CONTENT_TYPES) {
                RenderTypeLookup.setRenderLayer(type.getBlock(tier), (RenderType)RenderType.func_228643_e_());
            }
            ScreenManager.func_216911_a(ContentType.EXPORTER.getContainerType(tier), TieredExporterScreen::new);
            ScreenManager.func_216911_a(ContentType.IMPORTER.getContainerType(tier), TieredImporterScreen::new);
            ScreenManager.func_216911_a(ContentType.CONSTRUCTOR.getContainerType(tier), TieredConstructorScreen::new);
            ScreenManager.func_216911_a(ContentType.DESTRUCTOR.getContainerType(tier), TieredDestructorScreen::new);
            ScreenManager.func_216911_a(ContentType.DISK_MANIPULATOR.getContainerType(tier), TieredDiskManipulatorScreen::new);
            ScreenManager.func_216911_a(ContentType.REQUESTER.getContainerType(tier), TieredRequesterScreen::new);
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.EXPORTER.getName(tier)), (base, registry) -> new BakedModelCableCover(base));
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.IMPORTER.getName(tier)), (base, registry) -> new BakedModelCableCover(base));
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.CONSTRUCTOR.getName(tier)), (base, registry) -> new BakedModelCableCover((IBakedModel)new FullbrightBakedModel(base, true, new ResourceLocation[]{new ResourceLocation("refinedstorage", "block/constructor/cutouts/connected")})));
            bakedModelOverrideRegistry.add(new ResourceLocation("cabletiers", ContentType.DESTRUCTOR.getName(tier)), (base, registry) -> new BakedModelCableCover((IBakedModel)new FullbrightBakedModel(base, true, new ResourceLocation[]{new ResourceLocation("refinedstorage", "block/destructor/cutouts/connected")})));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = bakedModelOverrideRegistry.get(new ResourceLocation(id.func_110624_b(), id.func_110623_a()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((IBakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }
}

