/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.gui;

import com.YTrollman.CableTiers.container.TieredExporterContainer;
import com.YTrollman.CableTiers.gui.TieredScreen;
import com.YTrollman.CableTiers.node.TieredExporterNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredExporterTileEntity;
import com.YTrollman.CableTiers.util.MathUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TieredExporterScreen
extends TieredScreen<TieredExporterTileEntity, TieredExporterContainer, TieredExporterNetworkNode> {
    private boolean hasRegulatorMode = this.hasRegulatorMode();

    public TieredExporterScreen(TieredExporterContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 211, 119 + 18 * MathUtil.ceilDiv(9 * container.getTier().getSlotsMultiplier(), 9), inventory, title);
    }

    private boolean hasRegulatorMode() {
        return ((TieredExporterNetworkNode)((Object)this.getNode())).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
    }

    public void onPostInit(int x, int y) {
        this.addSideButton((SideButton)new RedstoneModeSideButton((BaseScreen)this, TieredExporterTileEntity.REDSTONE_MODE));
        this.addSideButton((SideButton)new TypeSideButton((BaseScreen)this, TieredExporterTileEntity.TYPE));
        this.addSideButton((SideButton)new ExactModeSideButton((BaseScreen)this, TieredExporterTileEntity.COMPARE));
    }

    @Override
    public void tick(int x, int y) {
        boolean updatedHasRegulatorMode = this.hasRegulatorMode();
        if (this.hasRegulatorMode != updatedHasRegulatorMode) {
            this.hasRegulatorMode = updatedHasRegulatorMode;
            ((TieredExporterContainer)this.field_147002_h).checkRegulator();
        }
    }

    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("cabletiers", "gui/" + this.getTier().getName() + "_exporter_importer_destructor.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void renderForeground(MatrixStack matrixStack, int i, int i1) {
        this.renderString(matrixStack, 7, 7, RenderUtils.shorten((String)this.field_230704_d_.getString(), (int)26));
        this.renderString(matrixStack, 7, 24 + 18 * MathUtil.ceilDiv(9 * this.getTier().getSlotsMultiplier(), 9), new TranslationTextComponent("container.inventory").getString());
    }
}

