/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.gui;

import com.YTrollman.CableTiers.container.TieredDestructorContainer;
import com.YTrollman.CableTiers.gui.TieredScreen;
import com.YTrollman.CableTiers.node.TieredDestructorNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredDestructorTileEntity;
import com.YTrollman.CableTiers.util.MathUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.WhitelistBlacklistSideButton;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class TieredDestructorScreen
extends TieredScreen<TieredDestructorTileEntity, TieredDestructorContainer, TieredDestructorNetworkNode> {
    public TieredDestructorScreen(TieredDestructorContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 211, 119 + 18 * MathUtil.ceilDiv(9 * container.getTier().getSlotsMultiplier(), 9), inventory, title);
    }

    public void onPostInit(int x, int y) {
        this.addSideButton((SideButton)new RedstoneModeSideButton((BaseScreen)this, TieredDestructorTileEntity.REDSTONE_MODE));
        this.addSideButton((SideButton)new TypeSideButton((BaseScreen)this, TieredDestructorTileEntity.TYPE));
        this.addSideButton((SideButton)new WhitelistBlacklistSideButton((BaseScreen)this, TieredDestructorTileEntity.WHITELIST_BLACKLIST));
        this.addSideButton((SideButton)new ExactModeSideButton((BaseScreen)this, TieredDestructorTileEntity.COMPARE));
        this.addSideButton(new TieredDestructorPickupSideButton(this));
    }

    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("cabletiers", "gui/" + this.getTier().getName() + "_exporter_importer_destructor.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, 24 + 18 * MathUtil.ceilDiv(9 * this.getTier().getSlotsMultiplier(), 9), I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
    }

    private static class TieredDestructorPickupSideButton
    extends SideButton {
        private TieredDestructorPickupSideButton(BaseScreen<?> screen) {
            super(screen);
        }

        protected void renderButtonIcon(MatrixStack matrixStack, int x, int y) {
            this.screen.func_238474_b_(matrixStack, x, y, 64 + (Boolean.TRUE.equals(TieredDestructorTileEntity.PICKUP.getValue()) ? 0 : 16), 0, 16, 16);
        }

        public String getTooltip() {
            return I18n.func_135052_a((String)"sidebutton.refinedstorage.destructor.pickup", (Object[])new Object[0]) + "\n" + TextFormatting.GRAY + I18n.func_135052_a((String)(Boolean.TRUE.equals(TieredDestructorTileEntity.PICKUP.getValue()) ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        }

        public void func_230930_b_() {
            TileDataManager.setParameter(TieredDestructorTileEntity.PICKUP, (Object)((Boolean)TieredDestructorTileEntity.PICKUP.getValue() == false ? 1 : 0));
        }
    }
}

