/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.CableTiers;
import com.YTrollman.CableTiers.blocks.TieredConstructorBlock;
import com.YTrollman.CableTiers.blocks.TieredDestructorBlock;
import com.YTrollman.CableTiers.blocks.TieredDiskManipulatorBlock;
import com.YTrollman.CableTiers.blocks.TieredExporterBlock;
import com.YTrollman.CableTiers.blocks.TieredImporterBlock;
import com.YTrollman.CableTiers.blocks.TieredRequesterBlock;
import com.YTrollman.CableTiers.container.TieredConstructorContainer;
import com.YTrollman.CableTiers.container.TieredContainer;
import com.YTrollman.CableTiers.container.TieredDestructorContainer;
import com.YTrollman.CableTiers.container.TieredDiskManipulatorContainer;
import com.YTrollman.CableTiers.container.TieredExporterContainer;
import com.YTrollman.CableTiers.container.TieredImporterContainer;
import com.YTrollman.CableTiers.container.TieredRequesterContainer;
import com.YTrollman.CableTiers.node.TieredConstructorNetworkNode;
import com.YTrollman.CableTiers.node.TieredDestructorNetworkNode;
import com.YTrollman.CableTiers.node.TieredDiskManipulatorNetworkNode;
import com.YTrollman.CableTiers.node.TieredExporterNetworkNode;
import com.YTrollman.CableTiers.node.TieredImporterNetworkNode;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.node.TieredRequesterNetworkNode;
import com.YTrollman.CableTiers.registry.RegistryHandler;
import com.YTrollman.CableTiers.tileentity.TieredConstructorTileEntity;
import com.YTrollman.CableTiers.tileentity.TieredDestructorTileEntity;
import com.YTrollman.CableTiers.tileentity.TieredDiskManipulatorTileEntity;
import com.YTrollman.CableTiers.tileentity.TieredExporterTileEntity;
import com.YTrollman.CableTiers.tileentity.TieredImporterTileEntity;
import com.YTrollman.CableTiers.tileentity.TieredRequesterTileEntity;
import com.YTrollman.CableTiers.tileentity.TieredTileEntity;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem;
import com.refinedmods.refinedstorage.tile.BaseTile;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cabletiers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ContentType<B extends BaseBlock, T extends TieredTileEntity<N>, C extends TieredContainer<T, N>, N extends TieredNetworkNode<N>> {
    public static final ContentType<TieredImporterBlock, TieredImporterTileEntity, TieredImporterContainer, TieredImporterNetworkNode> IMPORTER = new ContentType<TieredImporterBlock, TieredImporterTileEntity, TieredImporterContainer, TieredImporterNetworkNode>("importer", TieredImporterBlock::new, TieredImporterTileEntity::new, TieredImporterContainer::new, TieredImporterNetworkNode::new);
    public static final ContentType<TieredExporterBlock, TieredExporterTileEntity, TieredExporterContainer, TieredExporterNetworkNode> EXPORTER = new ContentType<TieredExporterBlock, TieredExporterTileEntity, TieredExporterContainer, TieredExporterNetworkNode>("exporter", TieredExporterBlock::new, TieredExporterTileEntity::new, TieredExporterContainer::new, TieredExporterNetworkNode::new);
    public static final ContentType<TieredConstructorBlock, TieredConstructorTileEntity, TieredConstructorContainer, TieredConstructorNetworkNode> CONSTRUCTOR = new ContentType<TieredConstructorBlock, TieredConstructorTileEntity, TieredConstructorContainer, TieredConstructorNetworkNode>("constructor", TieredConstructorBlock::new, TieredConstructorTileEntity::new, TieredConstructorContainer::new, TieredConstructorNetworkNode::new);
    public static final ContentType<TieredDestructorBlock, TieredDestructorTileEntity, TieredDestructorContainer, TieredDestructorNetworkNode> DESTRUCTOR = new ContentType<TieredDestructorBlock, TieredDestructorTileEntity, TieredDestructorContainer, TieredDestructorNetworkNode>("destructor", TieredDestructorBlock::new, TieredDestructorTileEntity::new, TieredDestructorContainer::new, TieredDestructorNetworkNode::new);
    public static final ContentType<TieredDiskManipulatorBlock, TieredDiskManipulatorTileEntity, TieredDiskManipulatorContainer, TieredDiskManipulatorNetworkNode> DISK_MANIPULATOR = new ContentType<TieredDiskManipulatorBlock, TieredDiskManipulatorTileEntity, TieredDiskManipulatorContainer, TieredDiskManipulatorNetworkNode>("disk_manipulator", TieredDiskManipulatorBlock::new, TieredDiskManipulatorTileEntity::new, TieredDiskManipulatorContainer::new, TieredDiskManipulatorNetworkNode::new);
    public static final ContentType<TieredRequesterBlock, TieredRequesterTileEntity, TieredRequesterContainer, TieredRequesterNetworkNode> REQUESTER = new ContentType<TieredRequesterBlock, TieredRequesterTileEntity, TieredRequesterContainer, TieredRequesterNetworkNode>("requester", TieredRequesterBlock::new, TieredRequesterTileEntity::new, TieredRequesterContainer::new, TieredRequesterNetworkNode::new);
    public static final ContentType<?, ?, ?, ?>[] CONTENT_TYPES = new ContentType[]{EXPORTER, IMPORTER, CONSTRUCTOR, DESTRUCTOR, DISK_MANIPULATOR, REQUESTER};
    private final Map<CableTier, RegistryObject<B>> blocks = new EnumMap<CableTier, RegistryObject<B>>(CableTier.class);
    private final Map<CableTier, RegistryObject<Item>> items = new EnumMap<CableTier, RegistryObject<Item>>(CableTier.class);
    private final Map<CableTier, RegistryObject<TileEntityType<T>>> tileEntityTypes = new EnumMap<CableTier, RegistryObject<TileEntityType<T>>>(CableTier.class);
    private final Map<CableTier, RegistryObject<ContainerType<C>>> containerTypes = new EnumMap<CableTier, RegistryObject<ContainerType<C>>>(CableTier.class);
    private final String name;
    private final Function<CableTier, B> blockFactory;
    private final Function<CableTier, T> tileEntityFactory;
    private final ContainerFactory<T, C> containerFactory;
    private final NetworkNodeFactory<N> networkNodeFactory;
    public static final ItemGroup CABLE_TIERS = new ItemGroup("cabletiers"){

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cabletiers:creative_importer")));
        }
    };

    private ContentType(String name, Function<CableTier, B> blockFactory, Function<CableTier, T> tileEntityFactory, ContainerFactory<T, C> containerFactory, NetworkNodeFactory<N> networkNodeFactory) {
        this.name = name;
        this.blockFactory = blockFactory;
        this.tileEntityFactory = tileEntityFactory;
        this.containerFactory = containerFactory;
        this.networkNodeFactory = networkNodeFactory;
    }

    public static void init() {
        for (ContentType<?, ?, ?, ?> type : CONTENT_TYPES) {
            super.initContent();
        }
    }

    @SubscribeEvent
    public static void registerWithRS(FMLCommonSetupEvent event) {
        for (ContentType<?, ?, ?, ?> type : CONTENT_TYPES) {
            super.registerContent();
        }
    }

    public B getBlock(CableTier tier) {
        return (B)((BaseBlock)this.blocks.get((Object)tier).get());
    }

    public Item getItem(CableTier tier) {
        return (Item)this.items.get((Object)tier).get();
    }

    public TileEntityType<T> getTileEntityType(CableTier tier) {
        return (TileEntityType)this.tileEntityTypes.get((Object)tier).get();
    }

    public ContainerType<C> getContainerType(CableTier tier) {
        return (ContainerType)this.containerTypes.get((Object)tier).get();
    }

    public String getName(CableTier tier) {
        return tier.getName() + "_" + this.name;
    }

    public ResourceLocation getId(CableTier tier) {
        return new ResourceLocation("cabletiers", this.getName(tier));
    }

    public C createContainer(int windowId, PlayerEntity player, T tile) {
        return (C)((Object)((TieredContainer)((Object)this.containerFactory.create(windowId, player, tile))));
    }

    public N createNetworkNode(World world, BlockPos pos, CableTier tier) {
        return (N)((Object)((TieredNetworkNode)((Object)this.networkNodeFactory.create(world, pos, tier))));
    }

    private void initContent() {
        for (CableTier tier : CableTier.VALUES) {
            String id = this.getName(tier);
            this.blocks.put(tier, RegistryHandler.BLOCKS.register(id, () -> (BaseBlock)this.blockFactory.apply(tier)));
            this.items.put(tier, (RegistryObject<Item>)RegistryHandler.ITEMS.register(id, () -> new BaseBlockItem(this.getBlock(tier), new Item.Properties().func_200916_a(CABLE_TIERS))));
            this.tileEntityTypes.put(tier, RegistryHandler.TILE_ENTITY_TYPES.register(id, () -> TileEntityType.Builder.func_223042_a(() -> (TieredTileEntity)((Object)((Object)((Object)this.tileEntityFactory.apply(tier)))), (Block[])new Block[]{this.getBlock(tier)}).func_206865_a(null)));
            this.containerTypes.put(tier, RegistryHandler.CONTAINER_TYPES.register(id, () -> IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                TileEntity tile = inv.field_70458_d.func_130014_f_().func_175625_s(pos);
                if (tile == null) {
                    CableTiers.LOGGER.error("Expected tile entity of type " + id + ", but found none");
                    return null;
                }
                TileEntityType<T> tileEntityType = this.getTileEntityType(tier);
                if (tile.func_200662_C() != tileEntityType) {
                    CableTiers.LOGGER.error("Wrong type of tile entity, expected " + tileEntityType.getRegistryName() + ", but got " + tile.func_200662_C().getRegistryName());
                    return null;
                }
                return this.createContainer(windowId, inv.field_70458_d, (TieredTileEntity)tile);
            })));
        }
    }

    private void registerContent() {
        for (CableTier tier : CableTier.VALUES) {
            API.instance().getNetworkNodeRegistry().add(this.getId(tier), (tag, world, pos) -> {
                N node = this.createNetworkNode(world, pos, tier);
                node.read(tag);
                return node;
            });
            ((TieredTileEntity)this.getTileEntityType(tier).func_200968_a()).getDataManager().getParameters().forEach(TileDataManager::registerParameter);
        }
    }

    @FunctionalInterface
    private static interface NetworkNodeFactory<N> {
        public N create(World var1, BlockPos var2, CableTier var3);
    }

    @FunctionalInterface
    private static interface ContainerFactory<T extends BaseTile, C extends Container> {
        public C create(int var1, PlayerEntity var2, T var3);
    }
}

