/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.tainted.save.TimedDataSave;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.tainted.save.UndoHistory;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntSupplier;
import net.minecraft.nbt.CompoundNBT;

public class UndoWorldSave
extends TimedDataSave<UndoValue> {
    private final IntSupplier undoMaxLength;

    public UndoWorldSave(String name, IntSupplier undoMaxLength) {
        super(name);
        this.undoMaxLength = Objects.requireNonNull(undoMaxLength);
    }

    public void insertUndo(UUID uuid, Undo undo) {
        UndoValue val = this.getAndUpdateTime(uuid);
        val.getHistory().add(undo);
    }

    public Optional<Undo> getUndo(UUID uuid) {
        return this.getAndUpdateTime(uuid).getHistory().get();
    }

    public Optional<Undo> peekSnapshot(UUID uuid) {
        return this.getAndUpdateTime(uuid).getHistory().peek();
    }

    public void removeHistory(UUID uuid) {
        this.remove(uuid);
    }

    private UndoValue getAndUpdateTime(UUID uuid) {
        UndoValue val = (UndoValue)this.get(uuid);
        val.updateTime();
        return val;
    }

    @Override
    protected UndoValue createValue() {
        return new UndoValue(this.undoMaxLength);
    }

    @Override
    protected UndoValue readValue(CompoundNBT nbt) {
        return new UndoValue(nbt, this.undoMaxLength);
    }

    static final class UndoValue
    extends TimedDataSave.TimedValue {
        private final UndoHistory history;

        private UndoValue(CompoundNBT nbt, IntSupplier supplier) {
            super(nbt);
            this.history = new UndoHistory(supplier);
            this.history.read(nbt);
        }

        private UndoValue(IntSupplier maxLength) {
            this.history = new UndoHistory(maxLength);
        }

        private UndoHistory getHistory() {
            return this.history;
        }

        @Override
        public CompoundNBT write() {
            CompoundNBT nbt = super.write();
            this.history.write(nbt);
            return nbt;
        }
    }
}

