/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.util.ref.NBTKeys;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

class SimpleMaterialListEntry
implements MaterialListEntry<SimpleMaterialListEntry> {
    static final MaterialListEntry.Serializer<SimpleMaterialListEntry> SERIALIZER = new Serializer();
    private final ImmutableMultiset<IUniqueObject<?>> items;

    SimpleMaterialListEntry(ImmutableMultiset<IUniqueObject<?>> items) {
        this.items = Objects.requireNonNull(items, "Cannot have a SimpleMaterialListEntry without any Materials!");
    }

    ImmutableMultiset<IUniqueObject<?>> getItems() {
        return this.items;
    }

    @Override
    public PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> iterator() {
        return Iterators.peekingIterator((Iterator)Iterators.singletonIterator(this.items));
    }

    @Override
    public MaterialListEntry.Serializer<SimpleMaterialListEntry> getSerializer() {
        return SERIALIZER;
    }

    public SimpleMaterialListEntry simplify() {
        return this;
    }

    private static class Serializer
    implements MaterialListEntry.Serializer<SimpleMaterialListEntry> {
        private static final Comparator<Multiset.Entry<IUniqueObject<?>>> COMPARATOR = Comparator.comparing(e -> ((IUniqueObject)e.getElement()).getObjectRegistryName()).thenComparingInt(Multiset.Entry::getCount);

        private Serializer() {
        }

        @Override
        public SimpleMaterialListEntry readFromNBT(CompoundNBT nbt, boolean persisted) {
            ListNBT nbtList = nbt.func_150295_c("data", 10);
            ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
            for (INBT nbtEntry : nbtList) {
                IUniqueObjectSerializer serializer;
                CompoundNBT compoundEntry = (CompoundNBT)nbtEntry;
                IUniqueObjectSerializer iUniqueObjectSerializer = serializer = persisted ? RegistryUtils.getFromString(Registries.getUniqueObjectSerializers(), compoundEntry.func_74779_i("serializer")) : RegistryUtils.getById(Registries.getUniqueObjectSerializers(), compoundEntry.func_74762_e("serializer"));
                if (serializer == null) {
                    BuildingGadgets.LOG.error("Found unknown UniqueItem serializer {}. Skipping!", (Object)compoundEntry.func_74779_i("serializer"));
                    continue;
                }
                builder.addCopies(serializer.deserialize(compoundEntry.func_74775_l("data")), compoundEntry.func_74762_e("count"));
            }
            return new SimpleMaterialListEntry(builder.build());
        }

        @Override
        public CompoundNBT writeToNBT(SimpleMaterialListEntry listEntry, boolean persisted) {
            CompoundNBT res = new CompoundNBT();
            ListNBT nbtList = new ListNBT();
            for (Multiset.Entry entry : listEntry.getItems().entrySet()) {
                CompoundNBT nbtEntry = new CompoundNBT();
                if (persisted) {
                    nbtEntry.func_74778_a("serializer", ((IUniqueObject)entry.getElement()).getSerializer().getRegistryName().toString());
                } else {
                    nbtEntry.func_74768_a("serializer", RegistryUtils.getId(Registries.getUniqueObjectSerializers(), ((IUniqueObject)entry.getElement()).getSerializer()));
                }
                nbtEntry.func_218657_a("data", (INBT)((IUniqueObject)entry.getElement()).getSerializer().serialize((IUniqueObject)entry.getElement(), persisted));
                nbtEntry.func_74768_a("count", entry.getCount());
                nbtList.add((Object)nbtEntry);
            }
            res.func_218657_a("data", (INBT)nbtList);
            return res;
        }

        @Override
        public JsonSerializer<SimpleMaterialListEntry> asJsonSerializer(boolean printName, boolean extended) {
            return (src, typeOfSrc, context) -> {
                ImmutableMultiset<IUniqueObject<?>> set = src.getItems();
                JsonArray jsonArray = new JsonArray();
                for (Multiset.Entry entry : ImmutableList.sortedCopyOf(COMPARATOR, (Iterable)set.entrySet())) {
                    JsonElement element = ((IUniqueObject)entry.getElement()).getSerializer().asJsonSerializer(printName, extended).serialize(entry.getElement(), ((IUniqueObject)entry.getElement()).getClass(), context);
                    JsonObject obj = new JsonObject();
                    obj.add("item_type", context.serialize((Object)((IUniqueObject)entry.getElement()).getSerializer().getRegistryName()));
                    obj.addProperty("count", (Number)entry.getCount());
                    obj.add("item", element);
                    jsonArray.add((JsonElement)obj);
                }
                return jsonArray;
            };
        }

        @Override
        public JsonDeserializer<SimpleMaterialListEntry> asJsonDeserializer() {
            return (json, typeOfT, context) -> {
                JsonArray array = json.getAsJsonArray();
                ImmutableMultiset.Builder items = ImmutableMultiset.builder();
                for (JsonElement element : array) {
                    JsonObject object = element.getAsJsonObject();
                    ResourceLocation id = (ResourceLocation)context.deserialize(object.get("item_type"), ResourceLocation.class);
                    IUniqueObjectSerializer serializer = (IUniqueObjectSerializer)Registries.getUniqueObjectSerializers().getValue(id);
                    if (serializer == null) continue;
                    int count = object.getAsJsonPrimitive("count").getAsInt();
                    IUniqueObject item = (IUniqueObject)serializer.asJsonDeserializer().deserialize(object.get("item"), IUniqueObject.class, context);
                    items.addCopies((Object)item, count);
                }
                return new SimpleMaterialListEntry(items.build());
            };
        }

        @Override
        public ResourceLocation getRegistryName() {
            return NBTKeys.SIMPLE_SERIALIZER_ID;
        }
    }
}

