/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.view;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.util.spliterator.DelegatingSpliterator;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public final class WorldBuildView
implements IBuildView {
    private final BuildContext context;
    private final Region region;
    private final BiFunction<BuildContext, BlockPos, Optional<BlockData>> dataFactory;
    private BlockPos translation;

    public static WorldBuildView create(BuildContext context, Region region) {
        return WorldBuildView.create(context, region, null);
    }

    public static WorldBuildView create(BuildContext context, Region region, @Nullable BiFunction<BuildContext, BlockPos, Optional<BlockData>> dataFactory) {
        return new WorldBuildView(Objects.requireNonNull(context, "Cannot create WorldBuildView without an BuildContext!"), Objects.requireNonNull(region, "Cannot create WorldBuildView without an Region!"), dataFactory != null ? dataFactory : (c, p) -> Optional.of(TileSupport.createBlockData((IBlockReader)c.getWorld(), p)));
    }

    private WorldBuildView(BuildContext context, Region region, BiFunction<BuildContext, BlockPos, Optional<BlockData>> dataFactory) {
        this.context = context;
        this.region = region;
        this.dataFactory = dataFactory;
        this.translation = BlockPos.field_177992_a;
    }

    @Override
    public Spliterator<PlacementTarget> spliterator() {
        return new WorldBackedSpliterator(this.getBoundingBox().stream().spliterator(), this.translation, this.dataFactory, this.getContext());
    }

    @Override
    public WorldBuildView translateTo(BlockPos pos) {
        this.translation = pos;
        return this;
    }

    @Override
    public int estimateSize() {
        return this.region.size();
    }

    @Override
    public WorldBuildView copy() {
        return new WorldBuildView(this.getContext(), this.getBoundingBox(), this.dataFactory);
    }

    @Override
    public BuildContext getContext() {
        return this.context;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    private static final class WorldBackedSpliterator
    extends DelegatingSpliterator<BlockPos, PlacementTarget> {
        private final BlockPos translation;
        private final BiFunction<BuildContext, BlockPos, Optional<BlockData>> dataFactory;
        private final BuildContext context;

        private WorldBackedSpliterator(Spliterator<BlockPos> other, BlockPos translation, BiFunction<BuildContext, BlockPos, Optional<BlockData>> dataFactory, BuildContext context) {
            super(other);
            this.translation = translation;
            this.dataFactory = dataFactory;
            this.context = context;
        }

        @Override
        protected boolean advance(BlockPos object, Consumer<? super PlacementTarget> action) {
            Optional<BlockData> dataOptional = this.dataFactory.apply(this.context, object);
            if (dataOptional.isPresent()) {
                BlockData data = dataOptional.get();
                action.accept(new PlacementTarget(object.func_177971_a((Vector3i)this.translation), data));
                return true;
            }
            return false;
        }

        @Override
        public Comparator<? super PlacementTarget> getComparator() {
            return Comparator.comparing(PlacementTarget::getPos);
        }

        @Override
        @Nullable
        public Spliterator<PlacementTarget> trySplit() {
            Spliterator<BlockPos> other = this.getOther().trySplit();
            if (other != null) {
                return new WorldBackedSpliterator(other, this.translation, this.dataFactory, this.context);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 21;
        }
    }
}

