/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.view;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

@Immutable
public final class BuildContext {
    @Nonnull
    private final IWorld world;
    @Nullable
    private final PlayerEntity player;
    private final ItemStack stack;

    public static Builder builder() {
        return new Builder();
    }

    public BuildContext(@Nonnull IWorld world, @Nullable PlayerEntity player, @Nonnull ItemStack stack) {
        this.world = world;
        this.player = player;
        this.stack = stack;
    }

    public IWorld getWorld() {
        return this.world;
    }

    @Nullable
    public PlayerEntity getPlayer() {
        return this.player;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ServerWorld getServerWorld() {
        return ((IServerWorld)this.world).func_201672_e();
    }

    public static final class Builder {
        @Nullable
        private IWorld world = null;
        @Nullable
        private PlayerEntity buildingPlayer = null;
        @Nonnull
        private ItemStack stack = ItemStack.field_190927_a;

        private Builder() {
        }

        public Builder world(@Nonnull IWorld world) {
            this.world = world;
            return this;
        }

        public Builder player(@Nullable PlayerEntity buildingPlayer) {
            this.buildingPlayer = buildingPlayer;
            if (this.world == null && buildingPlayer != null) {
                this.world = buildingPlayer.field_70170_p;
            }
            return this;
        }

        public Builder stack(@Nonnull ItemStack stack) {
            this.stack = stack;
            return this;
        }

        public BuildContext build() {
            return this.build(null);
        }

        public BuildContext build(@Nullable IWorld world) {
            return new BuildContext(world != null ? world : Objects.requireNonNull(this.world), this.buildingPlayer, this.stack);
        }
    }
}

