/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.direwolf20.buildinggadgets.common.capability.IPrivateEnergy;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public final class PlacementChecker {
    private final LazyOptional<IEnergyStorage> energyCap;
    private final ToIntFunction<PlacementTarget> energyFun;
    private final IItemIndex index;
    private final boolean firePlaceEvents;
    private final BiPredicate<BuildContext, PlacementTarget> placeCheck;

    public PlacementChecker(LazyOptional<IEnergyStorage> energyCap, ToIntFunction<PlacementTarget> energyFun, IItemIndex index, BiPredicate<BuildContext, PlacementTarget> placeCheck, boolean firePlaceEvents) {
        this.energyCap = energyCap;
        this.energyFun = energyFun;
        this.index = index;
        this.firePlaceEvents = firePlaceEvents;
        this.placeCheck = placeCheck;
    }

    public CheckResult checkPositionWithResult(BuildContext context, PlacementTarget target, boolean giveBackItems) {
        if (target.getPos().func_177956_o() > context.getWorld().func_217301_I() || target.getPos().func_177956_o() < 0 || !this.placeCheck.test(context, target)) {
            return new CheckResult(MatchResult.failure(), (Multiset)ImmutableMultiset.of(), false, false);
        }
        int energy = this.energyFun.applyAsInt(target);
        ImmutableMultiset insertedItems = ImmutableMultiset.of();
        boolean isCreative = context.getPlayer() != null && context.getPlayer().func_184812_l_();
        IPrivateEnergy storage = (IPrivateEnergy)this.energyCap.orElseThrow(CapabilityNotPresentException::new);
        if (!isCreative && storage.extractPower(energy, true) != energy) {
            return new CheckResult(MatchResult.failure(), (Multiset)insertedItems, false, false);
        }
        BlockRayTraceResult targetRayTrace = null;
        if (context.getPlayer() != null) {
            PlayerEntity player = context.getPlayer();
            targetRayTrace = CommonUtils.fakeRayTrace(player.func_213303_ch(), target.getPos());
        }
        MaterialList materials = target.getRequiredMaterials(context, (RayTraceResult)targetRayTrace);
        MatchResult match = this.index.tryMatch(materials);
        boolean usePaste = false;
        if (!match.isSuccess()) {
            match = this.index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return new CheckResult(match, (Multiset)insertedItems, false, false);
            }
            usePaste = true;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.create((RegistryKey)context.getServerWorld().func_234923_W_(), (IWorld)context.getWorld(), (BlockPos)target.getPos());
        boolean isAir = blockSnapshot.getCurrentBlock().isAir((IBlockReader)context.getWorld(), target.getPos());
        if (this.firePlaceEvents && ForgeEventFactory.onBlockPlace((Entity)context.getPlayer(), (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return new CheckResult(match, (Multiset)insertedItems, false, usePaste);
        }
        if (!isAir) {
            BlockEvent.BreakEvent e;
            if (this.firePlaceEvents && MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent((World)context.getServerWorld(), target.getPos(), blockSnapshot.getCurrentBlock(), context.getPlayer())))) {
                return new CheckResult(match, (Multiset)insertedItems, false, usePaste);
            }
            if (giveBackItems) {
                insertedItems = (Multiset)TileSupport.createTileData(context.getWorld().func_175625_s(target.getPos())).getRequiredItems(context, blockSnapshot.getCurrentBlock(), null, target.getPos()).iterator().next();
                this.index.insert((Multiset<IUniqueObject<?>>)insertedItems);
            }
        }
        boolean success = true;
        if (!isCreative) {
            success = storage.extractPower(energy, false) == energy;
        }
        success = success && this.index.applyMatch(match);
        return new CheckResult(match, (Multiset)insertedItems, success, usePaste);
    }

    public static final class CheckResult {
        private final MatchResult match;
        private final Multiset<IUniqueObject<?>> insertedItems;
        private final boolean success;
        private final boolean usingPaste;

        private CheckResult(MatchResult match, Multiset<IUniqueObject<?>> insertedItems, boolean success, boolean usingPaste) {
            this.match = match;
            this.insertedItems = insertedItems;
            this.success = success;
            this.usingPaste = usingPaste;
        }

        public Multiset<IUniqueObject<?>> getInsertedItems() {
            return this.insertedItems;
        }

        public MatchResult getMatch() {
            return this.match;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isUsingPaste() {
            return this.usingPaste;
        }
    }
}

