/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.tag;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionReader;
import net.minecraft.util.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.codec.ICodecProvider;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.imc.DataTagIMC;
import sirttas.dpanvil.api.tag.DataTagRegistry;

public class DataTagManager
implements IDataManager<ITagCollection<?>>,
ICodecProvider<Map<ResourceLocation, ITagCollection<?>>> {
    public static final ResourceLocation ID = DataPackAnvil.createRL("tags");
    private static final Codec<Pair<ResourceLocation, Map<ResourceLocation, List<ResourceLocation>>>> MAP_CODEC = Codec.pair((Codec)ResourceLocation.field_240908_a_.fieldOf("id").codec(), (Codec)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)ResourceLocation.field_240908_a_.listOf()).fieldOf("values").codec());
    private static final String FOLDER = "dpanvil_tags/";
    private BiMap<ResourceLocation, ITagCollection<?>> tagCollections = ImmutableBiMap.of();
    private Map<ResourceLocation, DataTagRegistry<?>> tagRegistries = Maps.newHashMap();
    private final Codec<Map<ResourceLocation, ITagCollection<?>>> codec = Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)new Codec<ITagCollection<?>>(){

        public <T> DataResult<T> encode(ITagCollection<?> input, DynamicOps<T> ops, T prefix) {
            return MAP_CODEC.encode(this.mapCollection(input), ops, prefix);
        }

        private <U> Pair<ResourceLocation, Map<ResourceLocation, List<ResourceLocation>>> mapCollection(ITagCollection<U> input) {
            ResourceLocation id = DataTagManager.this.getId(input);
            Object manager = DataPackAnvil.WRAPPER.getManager(id);
            HashMap map = Maps.newHashMap();
            input.func_241833_a().forEach((key, tag) -> map.put(key, tag.func_230236_b_().stream().map(manager::getId).filter(location -> !DataPackAnvilApi.ID_NONE.equals(location)).collect(Collectors.toList())));
            return Pair.of((Object)id, (Object)map);
        }

        public <T> DataResult<Pair<ITagCollection<?>, T>> decode(DynamicOps<T> ops, T input) {
            return MAP_CODEC.decode(ops, input).map(pair -> pair.mapFirst(this::mapToCollection));
        }

        private <U> ITagCollection<U> mapToCollection(Pair<ResourceLocation, Map<ResourceLocation, List<ResourceLocation>>> input) {
            ResourceLocation id = (ResourceLocation)input.getFirst();
            Object manager = DataPackAnvil.WRAPPER.getManager(id);
            HashMap map = Maps.newHashMap();
            ((Map)input.getSecond()).forEach((key, tag) -> {
                ITag.Builder builder = ITag.Builder.func_200047_a();
                tag.forEach(location -> builder.func_232961_a_(location, key.toString()));
                builder.func_232959_a_(map::get, loc -> manager.getOrDefault((ResourceLocation)loc, null)).ifPresent(builtTag -> map.put(key, builtTag));
            });
            return ITagCollection.func_242202_a((Map)map);
        }
    });

    @Override
    public Class<ITagCollection<?>> getContentType() {
        return ITagCollection.class;
    }

    @Override
    public Map<ResourceLocation, ITagCollection<?>> getData() {
        return this.tagCollections;
    }

    public boolean shouldLoad() {
        return !this.tagRegistries.isEmpty();
    }

    @Override
    public void setData(Map<ResourceLocation, ITagCollection<?>> map) {
        this.tagCollections = ImmutableBiMap.copyOf(map);
        map.forEach(this::injectTagCollection);
        DataPackAnvilApi.LOGGER.info("Loaded {} {}", (Object)this.tagCollections.size(), (Object)"DataPack Anvil TagCollection");
    }

    @Override
    public ResourceLocation getId(ITagCollection<?> value) {
        return (ResourceLocation)this.tagCollections.inverse().getOrDefault(value, (Object)DataPackAnvilApi.ID_NONE);
    }

    @Override
    public String getFolder() {
        return FOLDER;
    }

    public <T> void putTagRegistryFromIMC(Supplier<DataTagIMC<T>> messageSupplier) {
        DataTagIMC<T> imc = messageSupplier.get();
        this.tagRegistries.put(DataPackAnvil.WRAPPER.getId(imc.getManager()), imc.getRegistry());
    }

    @Override
    public Codec<Map<ResourceLocation, ITagCollection<?>>> getCodec() {
        return this.codec;
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        ArrayList ids = Lists.newArrayList();
        ArrayList readers = Lists.newArrayList();
        ArrayList completableFutures = Lists.newArrayList();
        DataPackAnvil.WRAPPER.getDataManagers().entrySet().stream().filter(e -> this.tagRegistries.get(e.getKey()) != null).forEach(entry -> {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            IDataManager manager = (IDataManager)entry.getValue();
            TagCollectionReader reader = this.getTagCollectionReader(id, manager);
            ids.add(id);
            readers.add(reader);
            completableFutures.add(reader.func_242224_a(resourceManager, backgroundExecutor));
        });
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])completableFutures.stream().toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(v -> {
            HashMap map = Maps.newHashMap();
            for (int i = 0; i < ids.size(); ++i) {
                ResourceLocation id = (ResourceLocation)ids.get(i);
                ITagCollection collection = ((TagCollectionReader)readers.get(i)).func_242226_a((Map)((CompletableFuture)completableFutures.get(i)).join());
                map.put(id, collection);
            }
            this.setData(map);
        }, gameExecutor);
    }

    private <T> void injectTagCollection(ResourceLocation id, ITagCollection<T> collection) {
        DataTagRegistry<?> tagRegistry = this.tagRegistries.get(id);
        tagRegistry.setCollection(collection);
    }

    private <T> TagCollectionReader<T> getTagCollectionReader(ResourceLocation id, IDataManager<T> manager) {
        return new TagCollectionReader(manager::getOptional, FOLDER + manager.getFolder(), id.toString());
    }
}

