/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.tag;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;

public final class DataTagRegistry<T> {
    private ITagCollection<T> collection;
    private final List<Tag> tags = Lists.newArrayList();

    @Deprecated
    public ITag.INamedTag<T> createWrapperTag(ResourceLocation id) {
        return this.makeWrapperTag(id);
    }

    public ITag.INamedTag<T> makeWrapperTag(ResourceLocation id) {
        return this.tags.stream().filter(tag -> ((Tag)tag).id.equals((Object)id)).findAny().orElseGet(() -> {
            Tag tag = new Tag(id);
            this.tags.add(tag);
            return tag;
        });
    }

    public ITag<T> getTag(ResourceLocation id) {
        return this.collection.func_199910_a(id);
    }

    public Lazy<ITag<T>> getLazyTag(ResourceLocation id) {
        return Lazy.of(() -> this.collection.func_199910_a(id));
    }

    public Optional<ITag<T>> getOptionalTag(ResourceLocation id) {
        return Optional.ofNullable(this.collection.func_199910_a(id));
    }

    public void setCollection(ITagCollection<T> collection) {
        this.collection = collection;
        this.tags.forEach(tag -> ((Tag)tag).refresh(collection));
    }

    private class Tag
    implements ITag.INamedTag<T> {
        private final ResourceLocation id;
        private ITag<T> containedTag;

        private Tag(ResourceLocation id) {
            this.id = id;
            this.containedTag = null;
        }

        private void refresh(ITagCollection<T> collection) {
            this.containedTag = collection.func_199910_a(this.id);
        }

        public boolean func_230235_a_(T element) {
            if (this.containedTag != null) {
                return this.containedTag.func_230235_a_(element);
            }
            return false;
        }

        public List<T> func_230236_b_() {
            if (this.containedTag != null) {
                return this.containedTag.func_230236_b_();
            }
            return Collections.emptyList();
        }

        public ResourceLocation func_230234_a_() {
            return this.id;
        }
    }
}

