/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AbstractListBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AnyBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NoneBlockPredicate;

public final class AndBlockPredicate
extends AbstractListBlockPredicate {
    public static final String NAME = "and";
    @ObjectHolder(value="dpanvil:and")
    public static final BlockPosPredicateType<AndBlockPredicate> TYPE = null;
    public static final Codec<AndBlockPredicate> CODEC = AndBlockPredicate.codec(AndBlockPredicate::new);

    public AndBlockPredicate(IBlockPosPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    public AndBlockPredicate(Iterable<IBlockPosPredicate> predicates) {
        super(predicates);
    }

    @Override
    public boolean test(IWorldReader world, BlockPos pos) {
        return this.predicates.stream().allMatch(predicate -> predicate.test(world, pos));
    }

    public BlockPosPredicateType<AndBlockPredicate> getType() {
        return TYPE;
    }

    @Override
    public IBlockPosPredicate and(IBlockPosPredicate ... predicates) {
        return new AndBlockPredicate(this.merge(Lists.newArrayList((Object[])predicates), AndBlockPredicate.class));
    }

    @Override
    public IBlockPosPredicate simplify() {
        List<IBlockPosPredicate> simplified;
        block5: {
            block4: {
                simplified = this.predicates.stream().map(IBlockPosPredicate::simplify).flatMap(p -> p instanceof AndBlockPredicate ? ((AndBlockPredicate)p).predicates.stream() : Stream.of(p)).filter(p -> !(p instanceof AnyBlockPredicate)).collect(Collectors.toList());
                if (simplified.isEmpty()) break block4;
                if (!simplified.stream().anyMatch(NoneBlockPredicate.class::isInstance)) break block5;
            }
            return IBlockPosPredicate.none();
        }
        if (simplified.size() == 1) {
            return (IBlockPosPredicate)simplified.get(0);
        }
        return new AndBlockPredicate(simplified);
    }
}

