/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import sirttas.dpanvil.api.codec.CodecHelper;

public class CodecRecipeSerializer<T extends IRecipe<?>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final Codec<T> codec;
    private final BiConsumer<T, ResourceLocation> idSetter;

    public CodecRecipeSerializer(Codec<T> codec, BiConsumer<T, ResourceLocation> idSetter) {
        this.codec = codec;
        this.idSetter = idSetter;
    }

    public T func_199425_a_(ResourceLocation recipeId, JsonObject json) {
        IRecipe recipe = (IRecipe)CodecHelper.decode(this.codec, (JsonElement)json);
        if (recipe != null) {
            this.idSetter.accept(recipe, recipeId);
        }
        return (T)recipe;
    }

    public T func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
        IRecipe recipe = (IRecipe)CodecHelper.decode(this.codec, buffer);
        if (recipe != null) {
            this.idSetter.accept(recipe, recipeId);
        }
        return (T)recipe;
    }

    public void func_199427_a_(PacketBuffer buffer, T recipe) {
        CodecHelper.encode(this.codec, recipe, buffer);
    }
}

