/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.solarflux.items.ItemsSF;
import org.zeith.solarflux.panels.JSHelper;
import org.zeith.solarflux.panels.SolarPanel;

public class SolarScriptEngine {
    final ScriptEngine engine;
    final Invocable engineInvocable;

    public SolarScriptEngine(Stream<String> lines) throws ScriptException {
        StringBuilder content = new StringBuilder();
        HashMap defines = new HashMap();
        lines.forEach(ln -> {
            AtomicReference<String> tmp = new AtomicReference<String>((String)ln);
            defines.forEach((src, dst) -> tmp.set(((String)tmp.get()).replaceAll((String)src, (String)dst)));
            ln = tmp.get();
            if (ln.startsWith("define ")) {
                String[] kv = ln.substring(7).split(" ", 2);
                if (kv.length == 2) {
                    defines.put(kv[0], kv[1]);
                }
                ln = "// Processed: " + ln;
            }
            if (ln.startsWith("import ") && ln.endsWith(";")) {
                String clazz = ln.substring(7, ln.length() - 1);
                ln = "var " + clazz.substring(clazz.lastIndexOf(46) + 1) + " = Java.type(\"" + clazz + "\");";
            }
            content.append((String)ln).append(System.lineSeparator());
        });
        this.engine = SolarScriptEngine.newEngine();
        this.engineInvocable = (Invocable)((Object)this.engine);
        this.engine.eval(content.toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void reloadRecipes(RegisterRecipesEvent e) {
        try {
            this.callFunction("registerRecipes", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable er) {
            er.printStackTrace();
        }
    }

    public Object callFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.engineInvocable.invokeFunction(name, args);
    }

    public static ScriptEngine newEngine() {
        ScriptEngine se = new ScriptEngineManager(null).getEngineByName("Nashorn");
        if (se == null) {
            se = new ScriptEngineManager().getEngineByName("Nashorn");
        }
        try {
            se.put("panel", se.eval("function(){return Java.type('" + SolarPanel.class.getName() + "').customBuilder();}"));
            se.put("ingredient", se.eval("function(e){return Java.type('" + RecipeHelper.class.getName() + "').fromComponent(e);}"));
            se.put("isEmpty", se.eval("function(e){return Java.type('" + RecipeHelper.class.getName() + "').isEmpty(e);}"));
            se.put("newMaterial", se.eval("function(name){return Java.type('" + ItemsSF.class.getName() + "').newJSItem(name);}"));
            se.put("item", se.eval("function(mod, id){var js=Java.type('" + JSHelper.class.getName() + "');if(!id){return js.item(mod);}else{return js.item(mod,id);}}"));
            se.put("tag", se.eval("function(mod, id){var js=Java.type('" + JSHelper.class.getName() + "');if(!id){return js.tag(mod);}else{return js.tag(mod,id);}}"));
            se.put("isModLoaded", se.eval("function(mod){return Java.type('" + ModList.class.getName() + "').get().isLoaded(mod);}"));
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return se;
    }
}

