/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;

public class JSItem
extends Item {
    private LanguageData langs;

    public JSItem(Item.Properties properties) {
        super(properties);
    }

    public LanguageData langBuilder() {
        return new LanguageData(this);
    }

    public boolean hasLang() {
        return this.langs != null;
    }

    public LanguageData getLang() {
        return this.langs;
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final JSItem material;

        public LanguageData(JSItem material) {
            this.material = material;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equals("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public JSItem build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.material.langs = this;
            return this.material;
        }
    }
}

