/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import org.lwjgl.opengl.GL11;
import org.zeith.hammerlib.client.screen.ScreenWTFMojang;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.container.SolarPanelContainer;
import org.zeith.solarflux.util.ComplexProgressManager;

public class SolarPanelScreen
extends ScreenWTFMojang<SolarPanelContainer> {
    private static final ResourceLocation ELEMENTS = new ResourceLocation("solarflux", "textures/gui/elements.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("solarflux", "textures/gui/solar.png");
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 50;
    private static final int GAUGE_INNER_WIDTH = 16;
    private static final int GAUGE_INNER_HEIGHT = 48;
    private static final int GAUGE_INNER_OFFSET_X = 1;
    private static final int GAUGE_INNER_OFFSET_Y = 1;
    private static final int GAUGE_SRC_X = 64;
    private static final int GAUGE_SRC_Y = 62;
    private static final int GAUGE_INNER_SRC_X = 0;
    private static final int GAUGE_INNER_SRC_Y = 64;
    private static final int BORDER_OFFSET = 8;
    public final SolarPanelTile solar;
    private final PlayerInventory pinv;
    public final ComplexProgressManager data;
    private List<IReorderingProcessor> tooltip = Lists.newArrayList();
    long energy;
    long capacity;
    long currentGeneration;
    long generation;
    float sunIntensity;

    public SolarPanelScreen(SolarPanelContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.data = screenContainer.progressHandler;
        this.pinv = inv;
        this.solar = screenContainer.panel;
        this.field_146999_f = 176;
        this.field_147000_g = 180;
    }

    public void func_231023_e_() {
        this.energy = this.data.getLong(0);
        this.capacity = this.data.getLong(8);
        this.currentGeneration = this.data.getLong(16);
        this.generation = this.data.getLong(24);
        this.sunIntensity = this.data.getFloat(32);
        super.func_231023_e_();
    }

    protected void func_230451_b_(MatrixStack mstack, int mouseX, int mouseY) {
        mstack.func_227860_a_();
        this.field_230712_o_.func_243248_b(mstack, this.pinv.func_200200_C_(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_243248_b(mstack, (ITextComponent)this.solar.func_195044_w().func_177230_c().func_235333_g_(), 8.0f, 4.0f, 0x404040);
        mstack.func_227861_a_(8.0, 14.0, 0.0);
        mstack.func_227862_a_(0.9f, 0.9f, 0.9f);
        this.field_230712_o_.func_238421_b_(mstack, I18n.func_135052_a((String)"info.solarflux.energy.stored1", (Object[])new Object[]{this.energy}), 0.0f, 0.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(mstack, I18n.func_135052_a((String)"info.solarflux.energy.capacity", (Object[])new Object[]{this.capacity}), 0.0f, 10.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(mstack, I18n.func_135052_a((String)"info.solarflux.energy.generation", (Object[])new Object[]{this.currentGeneration}), 0.0f, 20.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(mstack, I18n.func_135052_a((String)"info.solarflux.energy.efficiency", (Object[])new Object[]{this.generation > 0L ? Math.round(100.0 * (double)this.currentGeneration / (double)this.generation) : 0L}), 0.0f, 30.0f, 0x404040);
        mstack.func_227865_b_();
        int x = this.field_146999_f - 18 - 8;
        int y = 40;
        boolean hover = this.inBounds(x + this.field_147003_i, y + this.field_147009_r, 18, 50, mouseX, mouseY);
        if (hover) {
            GL11.glDisable((int)3553);
            this.func_238468_a_(mstack, x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(ELEMENTS);
            this.func_238474_b_(mstack, x, y, 82, 62, 18, 50);
            if (this.pinv.func_70445_o().func_190926_b()) {
                this.drawMouseOver(I18n.func_135052_a((String)"info.solarflux.energy.stored2", (Object[])new Object[]{this.energy, this.capacity}));
            }
        }
        if (hover = this.inBounds((x = this.field_146999_f - 36 - 8 - 4) + this.field_147003_i, (y = 40) + this.field_147009_r, 18, 50, mouseX, mouseY)) {
            GL11.glDisable((int)3553);
            this.func_238468_a_(mstack, x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(ELEMENTS);
            this.func_238474_b_(mstack, x, y, 82, 62, 18, 50);
            if (this.pinv.func_70445_o().func_190926_b()) {
                this.drawMouseOver(I18n.func_135052_a((String)"info.solarflux.sun.intensity", (Object[])new Object[]{Math.round(100.0f * this.sunIntensity)}));
            }
        }
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTime) {
        this.tooltip.clear();
        super.func_230430_a_(ms, mouseX, mouseY, partialTime);
        this.func_238654_b_(ms, this.tooltip, mouseX, mouseY);
    }

    protected void renderBackground(MatrixStack mstack, float partialTicks, int mouseX, int mouseY) {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(mstack, xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_230706_i_.func_110434_K().func_110577_a(ELEMENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawPower(mstack, xStart + this.field_146999_f - 18 - 8, yStart + 8 + 32, mouseX, mouseY);
        this.drawSun(mstack, xStart + this.field_146999_f - 36 - 8 - 4, yStart + 8 + 32, mouseX, mouseY);
        for (int i = 0; i < this.solar.upgradeInventory.getSlots(); ++i) {
            this.func_238474_b_(mstack, xStart + i * 18 + 8, yStart + 60, 18, 0, 18, 18);
        }
        this.func_238474_b_(mstack, xStart + 150, yStart + 8, 18, 18, 18, 18);
    }

    private void drawPower(MatrixStack mstack, int x, int y, int mx, int my) {
        this.func_238474_b_(mstack, x + 1, y + 1, 16, 64, 16, 48);
        float height = (float)this.energy * 48.0f / (float)this.capacity;
        float offset = 48.0f - height;
        this.drawTMR(mstack, x + 1, (float)(y + 1) + offset, 0.0f, 64.0f + offset, 16.0f, height);
        this.func_238474_b_(mstack, x, y, 64, 62, 18, 50);
    }

    private void drawSun(MatrixStack mstack, int x, int y, int mouseX, int mouseY) {
        this.func_238474_b_(mstack, x + 1, y + 1, 48, 64, 16, 48);
        float height = 48.0f * this.sunIntensity;
        float offset = 48.0f - height;
        this.drawTMR(mstack, x + 1, (float)(y + 1) + offset, 32.0f, 64.0f + offset, 16.0f, height);
        this.func_238474_b_(mstack, x, y, 64, 62, 18, 50);
    }

    public void drawTMR(MatrixStack mstack, float x, float y, float textureX, float textureY, float width, float height) {
        Matrix4f mat = mstack.func_227866_c_().func_227870_a_();
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(mat, x + 0.0f, y + height, zLevel).func_225583_a_((textureX + 0.0f) * 0.00390625f, (textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_227888_a_(mat, x + width, y + height, zLevel).func_225583_a_((textureX + width) * 0.00390625f, (textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_227888_a_(mat, x + width, y + 0.0f, zLevel).func_225583_a_((textureX + width) * 0.00390625f, (textureY + 0.0f) * 0.00390625f).func_181675_d();
        bufferbuilder.func_227888_a_(mat, x + 0.0f, y + 0.0f, zLevel).func_225583_a_((textureX + 0.0f) * 0.00390625f, (textureY + 0.0f) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean inBounds(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx < x + w && my >= y && my <= y + h;
    }

    public void drawMouseOver(String line) {
        if (line != null) {
            Arrays.stream(line.split("\n")).map(StringTextComponent::new).map(TextComponent::func_241878_f).forEach(this.tooltip::add);
        }
    }
}

