/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.attribute;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.solarflux.attribute.AttributeModRegistry;
import org.zeith.solarflux.attribute.EnumAttributeLayer;
import org.zeith.solarflux.attribute.IAttributeMod;
import org.zeith.solarflux.attribute.IAttributeProperty;

public class SimpleAttributeProperty
implements IAttributeProperty {
    public static final Logger LOG = LogManager.getLogger((String)"SolarFlux");
    protected double value;
    protected double base;
    protected boolean dirty = true;
    protected final EnumMap<EnumAttributeLayer, List<IAttributeMod>> mods = new EnumMap(EnumAttributeLayer.class);
    protected final BiMap<UUID, IAttributeMod> modsById = HashBiMap.create();

    public SimpleAttributeProperty() {
        for (EnumAttributeLayer l : EnumAttributeLayer.values()) {
            this.mods.put(l, new ArrayList());
        }
    }

    @Override
    public double getValue() {
        if (this.dirty) {
            return this.recalculateValue();
        }
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.base;
    }

    @Override
    public void setBaseValue(double value) {
        this.base = value;
        this.dirty = true;
    }

    public void setValue(double value) {
        this.value = value;
        this.dirty = false;
    }

    @Override
    public IAttributeMod getModifier(UUID uuid) {
        return (IAttributeMod)this.modsById.get((Object)uuid);
    }

    @Override
    public IAttributeMod removeModifier(UUID uuid) {
        IAttributeMod mod = (IAttributeMod)this.modsById.remove((Object)uuid);
        this.removeModifier(mod);
        return mod;
    }

    @Override
    public void removeModifier(IAttributeMod mod) {
        if (mod != null) {
            this.mods.get((Object)mod.getLayer()).remove(mod);
            this.modsById.inverse().remove((Object)mod);
            this.dirty = true;
        }
    }

    @Override
    public void applyModifier(IAttributeMod mod, UUID uuid) {
        if (mod != null) {
            IAttributeMod mod2 = (IAttributeMod)this.modsById.get((Object)uuid);
            if (mod2 != null) {
                throw new IllegalArgumentException("Duplicate attribute modifier with id '" + uuid + "'!");
            }
            List<IAttributeMod> mods = this.mods.get((Object)mod.getLayer());
            if (mods.contains(mod)) {
                throw new IllegalArgumentException("Attribute modifier '" + mod + "' is already present!");
            }
            mods.add(mod);
            this.modsById.put((Object)uuid, (Object)mod);
            this.dirty = true;
        }
    }

    @Override
    public double recalculateValue() {
        this.value = this.getBaseValue();
        for (EnumAttributeLayer l : EnumAttributeLayer.values()) {
            for (IAttributeMod mod : this.mods.get((Object)l)) {
                this.value = mod.operate(this.value);
            }
        }
        this.dirty = false;
        return this.value;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("Base", this.getBaseValue());
        ListNBT attrs = new ListNBT();
        for (IAttributeMod mod : this.modsById.values()) {
            String id = AttributeModRegistry.getId(mod);
            if (id == null) {
                LOG.info("Found not registered attribute: " + mod + ". Don't know how to handle, skipping.");
                continue;
            }
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("UUID", (UUID)this.modsById.inverse().get((Object)mod));
            tag.func_74780_a("Val", mod.getValue());
            tag.func_74778_a("Id", id);
            attrs.add((Object)tag);
        }
        nbt.func_218657_a("Modifiers", (INBT)attrs);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setBaseValue(nbt.func_74760_g("Base"));
        ListNBT attrs = nbt.func_150295_c("Modifiers", 10);
        for (int i = 0; i < attrs.size(); ++i) {
            CompoundNBT tag = attrs.func_150305_b(i);
            IAttributeMod mod = AttributeModRegistry.create(tag.func_74779_i("Id"), tag.func_74760_g("Val"));
            if (mod == null) {
                LOG.info("Found not registered attribute with id '" + tag.func_74779_i("Id") + "'. Don't know how to handle, skipping.");
                continue;
            }
            this.applyModifier(mod, tag.func_186857_a("UUID"));
        }
    }

    @Override
    public void clearAttributes() {
        for (EnumAttributeLayer l : EnumAttributeLayer.values()) {
            this.mods.get((Object)l).clear();
        }
        this.modsById.clear();
        this.value = this.getBaseValue();
        this.dirty = false;
    }
}

