/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.entities.overcharged_hammer;

import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.index.CAEntities;
import com.mrh0.createaddition.index.CAItems;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class OverchargedHammerEntity
extends AbstractArrowEntity {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(OverchargedHammerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> ENCHANTED = EntityDataManager.func_187226_a(OverchargedHammerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private ItemStack thrownStack = new ItemStack((IItemProvider)CAItems.OVERCHARGED_HAMMER.get());
    private boolean dealtDamage;
    public int returningTicks;

    public OverchargedHammerEntity(EntityType<OverchargedHammerEntity> type, World world) {
        super(type, world);
    }

    public OverchargedHammerEntity(World world, LivingEntity living, ItemStack stack) {
        super((EntityType)CAEntities.OVERCHARGED_HAMMER_ENTITY.get(), living, world);
        this.thrownStack = stack.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)stack)));
        this.field_70180_af.func_187227_b(ENCHANTED, (Object)stack.func_77962_s());
    }

    public OverchargedHammerEntity(World world, double x, double y, double z) {
        super((EntityType)CAEntities.OVERCHARGED_HAMMER_ENTITY.get(), x, y, z, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(ENCHANTED, (Object)false);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            int i = 3;
            this.func_203045_n(true);
            Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
            this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
            if (this.field_70170_p.field_72995_K) {
                this.field_70137_T = this.func_226278_cu_();
            }
            double d0 = 0.05 * (double)i;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
            if (this.returningTicks == 0) {
                // empty if block
            }
            ++this.returningTicks;
        }
        super.func_70071_h_();
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return (Boolean)this.field_70180_af.func_187225_a(ENCHANTED);
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d v1, Vector3d v2) {
        return this.dealtDamage ? null : super.func_213866_a(v1, v2);
    }

    protected void func_213868_a(EntityRayTraceResult entityRay) {
        BlockPos blockpos;
        Entity ownerEntity;
        Entity hitEntity = entityRay.func_216348_a();
        float f = 8.0f;
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)hitEntity;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)((ownerEntity = this.func_234616_v_()) == null ? this : ownerEntity));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_187686_e;
        if (hitEntity.func_70097_a(damagesource, f) && hitEntity instanceof LivingEntity) {
            LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
            if (ownerEntity instanceof LivingEntity) {
                if (hitLivingEntity instanceof PlayerEntity) {
                    hitLivingEntity.func_195064_c(new EffectInstance(CAEffects.SHOCKING, 20));
                } else {
                    hitLivingEntity.func_195064_c(new EffectInstance(CAEffects.SHOCKING, 40));
                }
                EnchantmentHelper.func_151384_a((LivingEntity)hitLivingEntity, (Entity)ownerEntity);
                EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)ownerEntity), (Entity)hitLivingEntity);
            }
            this.func_184548_a(hitLivingEntity);
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.thrownStack) && this.field_70170_p.func_226660_f_(blockpos = hitEntity.func_233580_cy_())) {
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightningboltentity.func_204809_d(ownerEntity instanceof ServerPlayerEntity ? (ServerPlayerEntity)ownerEntity : null);
            this.field_70170_p.func_217376_c((Entity)lightningboltentity);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_187689_f;
    }

    public void func_70100_b_(PlayerEntity player) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == player.func_110124_au()) {
            super.func_70100_b_(player);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("Hammer", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Hammer"));
        }
        this.dealtDamage = nbt.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.thrownStack)));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("Hammer", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        nbt.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_225516_i_() {
        byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.func_220321_a(0.25f, 0.25f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70027_ad() {
        return false;
    }
}

