/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelay;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.item.Multimeter;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class RedstoneRelayTileEntity
extends SmartTileEntity
implements IWireNode,
IHaveGoggleInformation,
IObserveTileEntity {
    private BlockPos[] connectionPos = new BlockPos[this.getNodeCount()];
    private int[] connectionIndecies = new int[this.getNodeCount()];
    private WireType[] connectionTypes = new WireType[this.getNodeCount()];
    public IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    public static Vector3f OFFSET_NORTH = new Vector3f(0.0f, -0.0625f, -0.3125f);
    public static Vector3f OFFSET_WEST = new Vector3f(-0.3125f, -0.0625f, 0.0f);
    public static Vector3f OFFSET_SOUTH = new Vector3f(0.0f, -0.0625f, 0.3125f);
    public static Vector3f OFFSET_EAST = new Vector3f(0.3125f, -0.0625f, 0.0f);
    public static Vector3f IN_VERTICAL_OFFSET_NORTH = new Vector3f(0.3125f, 0.0f, -0.0625f);
    public static Vector3f IN_VERTICAL_OFFSET_WEST = new Vector3f(-0.0625f, 0.0f, -0.3125f);
    public static Vector3f IN_VERTICAL_OFFSET_SOUTH = new Vector3f(-0.3125f, 0.0f, 0.0625f);
    public static Vector3f IN_VERTICAL_OFFSET_EAST = new Vector3f(0.0625f, 0.0f, 0.3125f);
    public static Vector3f OUT_VERTICAL_OFFSET_NORTH = new Vector3f(-0.3125f, 0.0f, -0.0625f);
    public static Vector3f OUT_VERTICAL_OFFSET_WEST = new Vector3f(-0.0625f, 0.0f, 0.3125f);
    public static Vector3f OUT_VERTICAL_OFFSET_SOUTH = new Vector3f(0.3125f, 0.0f, 0.0625f);
    public static Vector3f OUT_VERTICAL_OFFSET_EAST = new Vector3f(0.0625f, 0.0f, -0.3125f);
    public static final int CAPACITY = (Integer)Config.ACCUMULATOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.ACCUMULATOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get();
    private int demand = 0;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public RedstoneRelayTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.field_145850_b, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public Vector3f getNodeOffset(int node) {
        boolean vertical = (Boolean)this.func_195044_w().func_177229_b((Property)RedstoneRelay.VERTICAL);
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)RedstoneRelay.HORIZONTAL_FACING);
        if (node > 3) {
            switch (direction) {
                case NORTH: {
                    return vertical ? OUT_VERTICAL_OFFSET_NORTH : OFFSET_NORTH;
                }
                case WEST: {
                    return vertical ? OUT_VERTICAL_OFFSET_WEST : OFFSET_WEST;
                }
                case SOUTH: {
                    return vertical ? OUT_VERTICAL_OFFSET_SOUTH : OFFSET_SOUTH;
                }
                case EAST: {
                    return vertical ? OUT_VERTICAL_OFFSET_EAST : OFFSET_EAST;
                }
            }
        } else {
            switch (direction) {
                case NORTH: {
                    return vertical ? IN_VERTICAL_OFFSET_NORTH : OFFSET_SOUTH;
                }
                case WEST: {
                    return vertical ? IN_VERTICAL_OFFSET_WEST : OFFSET_EAST;
                }
                case SOUTH: {
                    return vertical ? IN_VERTICAL_OFFSET_SOUTH : OFFSET_NORTH;
                }
                case EAST: {
                    return vertical ? IN_VERTICAL_OFFSET_EAST : OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getNodeFromPos(Vector3d vec) {
        Direction dir = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)RedstoneRelay.HORIZONTAL_FACING);
        boolean vertical = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)RedstoneRelay.VERTICAL);
        boolean upper = true;
        vec = vec.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        if (vertical) {
            switch (dir) {
                case NORTH: {
                    upper = vec.func_82615_a() < 0.5;
                    break;
                }
                case WEST: {
                    upper = vec.func_82616_c() > 0.5;
                    break;
                }
                case SOUTH: {
                    upper = vec.func_82615_a() > 0.5;
                    break;
                }
                case EAST: {
                    upper = vec.func_82616_c() < 0.5;
                    break;
                }
            }
        } else {
            switch (dir) {
                case NORTH: {
                    upper = vec.func_82616_c() < 0.5;
                    break;
                }
                case WEST: {
                    upper = vec.func_82615_a() < 0.5;
                    break;
                }
                case SOUTH: {
                    upper = vec.func_82616_c() > 0.5;
                    break;
                }
                case EAST: {
                    upper = vec.func_82615_a() > 0.5;
                    break;
                }
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BlockPos getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndecies[node];
    }

    @Override
    public void setNode(int node, int other, BlockPos pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndecies[node] = other;
        this.connectionTypes[node] = type;
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    public void fromTag(BlockState state, CompoundNBT nbt, boolean clientPacket) {
        super.fromTag(state, nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    public void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.func_70296_d();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public BlockPos getMyPos() {
        return this.field_174879_c;
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        BlockState bs;
        if (this.awakeNetwork(this.field_145850_b)) {
            this.causeBlockUpdate();
        }
        if (!(bs = this.func_195044_w()).func_203425_a((Block)CABlocks.REDSTONE_RELAY.get())) {
            return;
        }
        if (((Boolean)bs.func_177229_b((Property)RedstoneRelay.POWERED)).booleanValue()) {
            this.networkOut.push(this.networkIn.pull(this.demand));
            this.demand = this.networkIn.demand(this.networkOut.getDemand());
        }
    }

    public void func_145843_s() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            IWireNode node = this.getNode(i);
            if (node == null) break;
            node.removeNode(this.getOtherNodeIndex(i));
            node.invalidateNodeCache();
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        super.func_145843_s();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndeciesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
        if (ray == null) {
            return false;
        }
        int node = this.getNodeFromPos(ray.func_216347_e());
        ObservePacket.send(this.field_174879_c, node);
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.relay.info").func_240699_a_(TextFormatting.WHITE)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.selected").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)new TranslationTextComponent(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output").func_240699_a_(TextFormatting.AQUA)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.usage").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_240702_b_(" ").func_240702_b_(Multimeter.format(EnergyNetworkPacket.clientBuff)).func_240702_b_("fe/t").func_240699_a_(TextFormatting.AQUA));
        return true;
    }

    @Override
    public void onObserved(ServerPlayerEntity player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_174879_c, this.getNetwork(pack.getNode()).getPulled(), this.getNetwork(pack.getNode()).getPushed(), player);
        }
    }
}

