/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.wand;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.wand.RecipeDreamwoodWand;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityCorporeaSpark;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.item.ItemSparkUpgrade;
import vazkii.botania.common.item.ItemTwigWand;

public class ItemDreamwoodWand
extends ItemTwigWand
implements Registerable {
    public ItemDreamwoodWand(Item.Properties builder) {
        super(builder);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
    }

    public Set<Object> getAdditionalRegisters() {
        return ImmutableSet.of(RecipeDreamwoodWand.SERIALIZER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        defer.accept(() -> {
            ItemModelsProperties.func_239418_a_((Item)ModItems.dreamwoodTwigWand, (ResourceLocation)new ResourceLocation(MythicBotany.getInstance().modid, "bindmode"), (stack, world, entity) -> ItemTwigWand.getBindMode((ItemStack)stack) ? 1.0f : 0.0f);
            Minecraft.func_71410_x().getItemColors().func_199877_a((stack, colorId) -> colorId == 1 ? DyeColor.func_196056_a((int)ItemDreamwoodWand.getColor1((ItemStack)stack)).getColorValue() : (colorId == 2 ? DyeColor.func_196056_a((int)ItemDreamwoodWand.getColor2((ItemStack)stack)).getColorValue() : -1), new IItemProvider[]{ModItems.dreamwoodTwigWand});
        });
        MinecraftForge.EVENT_BUS.addListener(this::onRenderGameOverlay);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e == null || minecraft.field_71439_g == null) {
            return;
        }
        RayTraceResult pos = minecraft.field_71476_x;
        if (pos != null) {
            Block block;
            BlockPos bpos = pos.func_216346_c() == RayTraceResult.Type.BLOCK ? ((BlockRayTraceResult)pos).func_216350_a() : null;
            BlockState state = bpos != null ? minecraft.field_71441_e.func_180495_p(bpos) : null;
            Block block2 = block = state == null ? null : state.func_177230_c();
            if (PlayerHelper.hasAnyHeldItem((PlayerEntity)minecraft.field_71439_g) && PlayerHelper.hasHeldItem((PlayerEntity)minecraft.field_71439_g, (Item)ModItems.dreamwoodTwigWand) && block instanceof IWandHUD) {
                event.getMatrixStack().func_227860_a_();
                minecraft.func_213239_aq().func_76320_a("wandItemDreamwood");
                ((IWandHUD)block).renderHUD(event.getMatrixStack(), minecraft, (World)minecraft.field_71441_e, bpos);
                minecraft.func_213239_aq().func_76319_b();
                event.getMatrixStack().func_227865_b_();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (!world.field_72995_K && !held.func_190926_b() && held.func_77973_b() == ModItems.dreamwoodTwigWand) {
            if (event.getTarget() instanceof EntitySpark) {
                EntitySpark spark = (EntitySpark)event.getTarget();
                if (player.func_225608_bj_()) {
                    if (spark.getUpgrade() != SparkUpgradeType.NONE) {
                        spark.func_70099_a(ItemSparkUpgrade.getByType((SparkUpgradeType)spark.getUpgrade()), 0.0f);
                        spark.setUpgrade(SparkUpgradeType.NONE);
                        spark.getTransfers().clear();
                    } else {
                        spark.func_70099_a(new ItemStack((IItemProvider)vazkii.botania.common.item.ModItems.spark), 0.0f);
                        spark.func_70106_y();
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.func_233537_a_((boolean)false));
                } else {
                    SparkHelper.getSparksAround((World)world, (double)spark.func_226277_ct_(), (double)(spark.func_226278_cu_() + (double)(spark.func_213302_cg() / 2.0f)), (double)spark.func_226281_cx_(), (DyeColor)spark.getNetwork()).forEach(otherSpark -> EntitySpark.particleBeam((PlayerEntity)player, (Entity)spark, (Entity)((Entity)otherSpark)));
                }
            } else if (event.getTarget() instanceof EntityCorporeaSpark) {
                EntityCorporeaSpark spark = (EntityCorporeaSpark)event.getTarget();
                if (player.func_225608_bj_()) {
                    boolean master = spark.isMaster();
                    spark.func_70099_a(new ItemStack((IItemProvider)(master ? vazkii.botania.common.item.ModItems.corporeaSparkMaster : vazkii.botania.common.item.ModItems.corporeaSpark)), 0.0f);
                    spark.func_70106_y();
                    if (master) {
                        spark.getConnections().clear();
                        spark.getRelatives().clear();
                        if (spark.getMaster() != null) {
                            ICorporeaSpark oldMaster = spark.getMaster();
                            ObfuscationReflectionHelper.setPrivateValue(EntityCorporeaSpark.class, (Object)spark, null, (String)"master");
                            oldMaster.registerConnections(oldMaster, (ICorporeaSpark)spark, new ArrayList());
                        }
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.func_233537_a_((boolean)false));
                } else {
                    ItemDreamwoodWand.displayRelatives(player, new ArrayList<ICorporeaSpark>(), spark.getMaster());
                }
            }
        }
    }

    private static void displayRelatives(PlayerEntity player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
        if (spark != null) {
            List sparks = spark.getRelatives();
            if (sparks.isEmpty()) {
                EntitySpark.particleBeam((PlayerEntity)player, (Entity)((Entity)spark), (Entity)((Entity)spark.getMaster()));
            } else {
                for (ICorporeaSpark endSpark : sparks) {
                    if (checked.contains(endSpark)) continue;
                    EntitySpark.particleBeam((PlayerEntity)player, (Entity)((Entity)spark), (Entity)((Entity)endSpark));
                    checked.add(endSpark);
                    ItemDreamwoodWand.displayRelatives(player, checked, endSpark);
                }
            }
        }
    }

    @Nonnull
    protected String func_195935_o() {
        return vazkii.botania.common.item.ModItems.twigWand.func_77658_a();
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i < 16; ++i) {
                stacks.add((Object)ItemDreamwoodWand.forColors(i, i));
            }
        }
    }

    public static ItemStack forColors(int color1, int color2) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.dreamwoodTwigWand);
        ItemNBTHelper.setInt((ItemStack)stack, (String)"color1", (int)color1);
        ItemNBTHelper.setInt((ItemStack)stack, (String)"color2", (int)color2);
        return stack;
    }
}

