/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.patchouli;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import mythicbotany.MythicBotany;
import mythicbotany.patchouli.PageRuneRitualBase;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.botania.client.patchouli.component.ManaComponent;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class PageRitualInfo
extends PageRuneRitualBase {
    public static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation(MythicBotany.getInstance().modid, "textures/gui/patchouli_ritual_info.png");
    @SerializedName(value="text")
    public String text;
    private transient ManaComponent manaComponent;
    private transient BookTextRenderer desc;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.manaComponent = new ManaComponent();
        this.manaComponent.build(7, 115, pageNum);
        if (this.recipe != null) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            outputs.addAll(this.recipe.getOutputs());
            if (this.recipe.getSpecialOutput() != null) {
                outputs.addAll(this.recipe.getSpecialOutput().getJeiOutputItems());
            }
            for (ItemStack stack : outputs) {
                entry.addRelevantStack(stack, pageNum);
            }
        }
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.text != null) {
            StringTextComponent tc = this.text.isEmpty() ? new StringTextComponent("") : (parent.book.i18n ? new TranslationTextComponent(this.text) : new StringTextComponent(this.text));
            this.desc = new BookTextRenderer((GuiBook)parent, (ITextComponent)tc, 1, 64);
        }
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.mc.field_71446_o.func_110577_a(OVERLAY_TEXTURE);
        RenderSystem.enableBlend();
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)116, (int)156, (int)256, (int)256);
        this.renderInputs(matrixStack, mouseX, mouseY, partialTicks);
        this.renderOutputs(matrixStack, mouseX, mouseY, partialTicks);
        this.renderManaBar(matrixStack, mouseX, mouseY, partialTicks);
        if (this.desc != null) {
            this.desc.render(matrixStack, mouseX, mouseY);
        }
    }

    private void renderInputs(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe != null) {
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            inputs.addAll(this.recipe.getInputs());
            if (this.recipe.getSpecialInput() != null) {
                inputs.addAll(this.recipe.getSpecialInput().getJeiInputItems());
            }
            int startX = 58 - 8 * inputs.size();
            for (int i = 0; i < inputs.size(); ++i) {
                this.parent.renderIngredient(matrixStack, startX + 16 * i, 12, mouseX, mouseY, (Ingredient)inputs.get(i));
            }
        }
    }

    private void renderOutputs(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe != null) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            outputs.addAll(this.recipe.getOutputs());
            if (this.recipe.getSpecialOutput() != null) {
                outputs.addAll(this.recipe.getSpecialOutput().getJeiOutputItems());
            }
            int startX = 58 - 8 * outputs.size();
            for (int i = 0; i < outputs.size(); ++i) {
                this.parent.renderItemStack(matrixStack, startX + 16 * i, 41, mouseX, mouseY, (ItemStack)outputs.get(i));
            }
        }
    }

    private void renderManaBar(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe != null && this.recipe.getMana() > 0) {
            this.manaComponent.mana = IVariable.wrap((Number)this.recipe.getMana());
            this.manaComponent.onVariablesAvailable(v -> v);
            this.manaComponent.render(matrixStack, (IComponentRenderContext)this.parent, partialTicks, mouseX, mouseY);
        }
    }
}

