/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.patchouli;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class MultipleInputsComponent
implements ICustomComponent {
    @SerializedName(value="recipe_name")
    public String recipeName;
    protected transient List<Ingredient> ingredients;
    protected transient int x;
    protected transient int y;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX != -1 ? componentX : 17;
        this.y = componentY;
        this.ingredients = this.makeIngredients();
    }

    private List<Ingredient> makeIngredients() {
        AtomicReference<Object> recipe = new AtomicReference<Object>(null);
        Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(new ResourceLocation(this.recipeName)).ifPresent(recipe::set);
        if (recipe.get() == null) {
            throw new RuntimeException("Missing recipe: " + this.recipeName);
        }
        return ((IRecipe)recipe.get()).func_192400_c();
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        int widthHalf = 20 * this.ingredients.size() / 2;
        for (int i = 0; i < this.ingredients.size(); ++i) {
            context.renderIngredient(matrixStack, this.x - widthHalf + 9 + 20 * i, this.y, mouseX, mouseY, this.ingredients.get(i));
        }
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
    }
}

