/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.jei.LittleBoxItemRenderer;
import mythicbotany.rune.RuneRitualRecipe;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.client.core.handler.HUDHandler;

public class RuneRitualCategory
implements IRecipeCategory<RuneRitualRecipe> {
    public static final ResourceLocation UID = new ResourceLocation(MythicBotany.getInstance().modid, "jei_category_rune_ritual");
    private final IDrawable background;
    private final IDrawable slot;
    private final String localizedName;
    private final IDrawable icon;
    private final Map<ResourceLocation, Pair<Integer, Integer>> inputOutputSizes = new HashMap<ResourceLocation, Pair<Integer, Integer>>();

    public RuneRitualCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation(MythicBotany.getInstance().modid, "textures/gui/jei_ritual.png"), 0, 0, 136, 196);
        this.slot = guiHelper.getSlotDrawable();
        this.localizedName = I18n.func_135052_a((String)"tooltip.mythicbotany.rune_ritual", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.fimbultyrTablet));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends RuneRitualRecipe> getRecipeClass() {
        return RuneRitualRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull RuneRitualRecipe recipe, @Nonnull IIngredients ii) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(recipe.getCenterRune());
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            inputs.add(rune.getRune());
        }
        inputs.addAll(recipe.getInputs());
        if (recipe.getSpecialInput() != null) {
            inputs.addAll(recipe.getSpecialInput().getJeiInputItems());
        }
        ii.setInputIngredients(inputs);
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        outputs.addAll(recipe.getOutputs());
        if (recipe.getSpecialOutput() != null) {
            outputs.addAll(recipe.getSpecialOutput().getJeiOutputItems());
        }
        ii.setOutputs(VanillaTypes.ITEM, outputs);
        this.inputOutputSizes.put(recipe.func_199560_c(), (Pair<Integer, Integer>)Pair.of((Object)(inputs.size() - (1 + recipe.getRunes().size())), (Object)outputs.size()));
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull RuneRitualRecipe recipe, @Nonnull IIngredients ii) {
        this.initRunePositioned(layout, 0, 0, 0, true);
        for (int i = 0; i < recipe.getRunes().size(); ++i) {
            this.initRunePositioned(layout, i + 1, recipe.getRunes().get(i).getX(), recipe.getRunes().get(i).getZ(), recipe.getRunes().get(i).isConsumed());
        }
        int baseInputId = 1 + recipe.getRunes().size();
        int inputSize = ii.getInputs(VanillaTypes.ITEM).size() - baseInputId;
        int startInX = 68 - inputSize * 9;
        for (int i = 0; i < inputSize; ++i) {
            layout.getItemStacks().init(baseInputId + i, true, startInX + i * 18, 137);
        }
        int outputSize = ii.getOutputs(VanillaTypes.ITEM).size();
        int startOutX = 68 - outputSize * 9;
        for (int i = 0; i < outputSize; ++i) {
            layout.getItemStacks().init(baseInputId + inputSize + i, false, startOutX + i * 18, 169);
        }
        layout.getItemStacks().set(ii);
    }

    public void draw(RuneRitualRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        if (this.inputOutputSizes.containsKey(recipe.func_199560_c())) {
            Pair<Integer, Integer> sizes = this.inputOutputSizes.get(recipe.func_199560_c());
            int startInX = 68 - (Integer)sizes.getLeft() * 9;
            for (int i = 0; i < (Integer)sizes.getLeft(); ++i) {
                this.slot.draw(matrixStack, startInX + i * 18, 137);
            }
            int startOutX = 68 - (Integer)sizes.getRight() * 9;
            for (int i = 0; i < (Integer)sizes.getRight(); ++i) {
                this.slot.draw(matrixStack, startOutX + i * 18, 169);
            }
        }
        if (recipe.getMana() > 0) {
            HUDHandler.renderManaBar((MatrixStack)matrixStack, (int)17, (int)189, (int)255, (float)0.75f, (int)recipe.getMana(), (int)1000000);
        }
    }

    private void initRunePositioned(@Nonnull IRecipeLayout layout, int idx, int x, int z, boolean consume) {
        int realX = 2 + 12 * (x + 5);
        int realZ = 2 + 12 * (-z + 5);
        layout.getItemStacks().init(idx, true, (IIngredientRenderer)LittleBoxItemRenderer.getRenderer(x, z, consume), realX, realZ, 12, 12, 0, 0);
    }
}

