/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mythicbotany.ModBlocks;
import mythicbotany.MythicBotany;
import mythicbotany.infuser.IInfuserRecipe;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateDrawable;

public class InfusionCategory
implements IRecipeCategory<IInfuserRecipe> {
    public static final ResourceLocation UID = new ResourceLocation(MythicBotany.getInstance().modid, "jei_category_infusion");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable infuserPlate;

    public InfusionCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 141);
        this.localizedName = I18n.func_135052_a((String)"block.mythicbotany.mana_infuser", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/terrasteel_jei_overlay.png"), 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.manaInfuser));
        IDrawable shimmerrock = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)vazkii.botania.common.block.ModBlocks.shimmerrock));
        this.infuserPlate = new TerraPlateDrawable(shimmerrock, shimmerrock, guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_150340_R)));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IInfuserRecipe> getRecipeClass() {
        return IInfuserRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull IInfuserRecipe recipe, @Nonnull IIngredients ii) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            list.add(Arrays.asList(ingredient.func_193365_a()));
        }
        ii.setInputLists(VanillaTypes.ITEM, list);
        ii.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull IInfuserRecipe recipe, @Nonnull IIngredients ii) {
        layout.getItemStacks().init(0, false, 48, 37);
        layout.getItemStacks().set(0, (List)ii.getOutputs(VanillaTypes.ITEM).get(0));
        double angle = 360.0 / (double)ii.getInputs(VanillaTypes.ITEM).size();
        Vector2f point = new Vector2f(48.0f, 5.0f);
        Vector2f center = new Vector2f(48.0f, 37.0f);
        for (int i = 1; i <= ii.getInputs(VanillaTypes.ITEM).size(); ++i) {
            layout.getItemStacks().init(i, true, Math.round(point.field_189982_i), Math.round(point.field_189983_j));
            layout.getItemStacks().set(i, (List)ii.getInputs(VanillaTypes.ITEM).get(i - 1));
            point = PetalApothecaryRecipeCategory.rotatePointAbout((Vector2f)point, (Vector2f)center, (double)angle);
        }
        layout.getItemStacks().init(ii.getInputs(VanillaTypes.ITEM).size() + 1, true, 48, 92);
        layout.getItemStacks().set(ii.getInputs(VanillaTypes.ITEM).size() + 1, new ItemStack(ModBlocks.manaInfuser));
    }

    public void draw(IInfuserRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(matrixStack, 25, 14);
        HUDHandler.renderManaBar((MatrixStack)matrixStack, (int)6, (int)126, (int)255, (float)0.75f, (int)recipe.getManaUsage(), (int)4000000);
        this.infuserPlate.draw(matrixStack, 35, 92);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        IFormattableTextComponent manaAmount = new StringTextComponent(BigDecimal.valueOf((double)recipe.getManaUsage() / 1000000.0).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).func_240699_a_(TextFormatting.BLUE);
        TranslationTextComponent tc = new TranslationTextComponent("tooltip.mythicbotany.cost_pools", new Object[]{manaAmount});
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, (ITextComponent)tc, (float)(57 - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)tc) / 2), 133.0f, 0);
    }
}

