/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.infuser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModRecipes;
import mythicbotany.infuser.IInfuserRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class InfuserRecipe
implements IInfuserRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;
    private final int mana;
    private final int fromColor;
    private final int toColor;

    public InfuserRecipe(ResourceLocation id, ItemStack output, int mana, int fromColor, int toColor, Ingredient ... inputs) {
        this.id = id;
        this.output = output;
        this.mana = mana;
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])inputs);
    }

    @Override
    public int getManaUsage() {
        return this.mana;
    }

    @Override
    public int fromColor() {
        return this.fromColor;
    }

    @Override
    public int toColor() {
        return this.toColor;
    }

    public boolean func_77569_a(@Nonnull IInventory inv, @Nonnull World worldIn) {
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        IntStream.range(0, inv.func_70302_i_()).boxed().map(arg_0 -> ((IInventory)inv).func_70301_a(arg_0)).filter(stack -> !stack.func_190926_b()).forEach(stack -> ingredientsMissing.stream().filter(ingredient -> ingredient.test(stack)).findFirst().ifPresent(ingredientsMissing::remove));
        return ingredientsMissing.isEmpty();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.INFUSER_SERIALIZER;
    }

    @Override
    public ItemStack result(List<ItemStack> inputs) {
        if (inputs.size() != this.inputs.size()) {
            return ItemStack.field_190927_a;
        }
        block0: for (Ingredient item : this.inputs) {
            for (ItemStack stack : inputs) {
                if (!item.test(stack)) continue;
                continue block0;
            }
            return ItemStack.field_190927_a;
        }
        return this.output.func_77946_l();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @Nullable
    public static Pair<IInfuserRecipe, ItemStack> getOutput(World world, List<ItemStack> inputs) {
        if (!inputs.isEmpty()) {
            if (inputs.stream().anyMatch(stack -> stack.func_190916_E() != 1)) {
                return null;
            }
            for (IRecipe recipe : world.func_199532_z().func_215366_a(ModRecipes.INFUSER).values()) {
                ItemStack stack2;
                if (!(recipe instanceof IInfuserRecipe) || (stack2 = ((IInfuserRecipe)recipe).result(inputs)).func_190926_b()) continue;
                return Pair.of((Object)((IInfuserRecipe)recipe), (Object)stack2.func_77946_l());
            }
        }
        return null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfuserRecipe> {
        @Nonnull
        public InfuserRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            int mana = JSONUtils.func_151203_m((JsonObject)json, (String)"mana");
            int fromColor = JSONUtils.func_151203_m((JsonObject)json, (String)"fromColor");
            int toColor = JSONUtils.func_151203_m((JsonObject)json, (String)"toColor");
            JsonArray ingrs = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new InfuserRecipe(recipeId, output, mana, fromColor, toColor, inputs.toArray(new Ingredient[0]));
        }

        @Nullable
        public InfuserRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            Ingredient[] inputs = new Ingredient[buffer.readInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            ItemStack output = buffer.func_150791_c();
            int mana = buffer.readInt();
            int fromColor = buffer.readInt();
            int toColor = buffer.readInt();
            return new InfuserRecipe(recipeId, output, mana, fromColor, toColor, inputs);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull InfuserRecipe recipe) {
            buffer.writeInt(recipe.func_192400_c().size());
            for (Ingredient input : recipe.func_192400_c()) {
                input.func_199564_a(buffer);
            }
            buffer.writeItemStack(recipe.func_77571_b(), false);
            buffer.writeInt(recipe.getManaUsage());
            buffer.writeInt(recipe.fromColor);
            buffer.writeInt(recipe.toColor);
        }
    }
}

