/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFloatingFunctionalFlower;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.wand.IWandBindable;

public abstract class FunctionalFlowerBase
extends TileEntityBase
implements ITickableTileEntity,
IWandBindable {
    public static final int DEFAULT_MAX_MANA = 300;
    public static final int DEFAULT_MAX_TRANSFER = 30;
    public final int maxMana;
    public final int maxTransfer;
    public final int color;
    public final boolean isGenerating;
    @Nullable
    private BlockPos pool = null;
    @Nullable
    private IManaPool poolTile = null;
    @Nullable
    private IManaCollector spreaderTile = null;
    protected int mana = 0;
    private boolean floating = false;
    private transient int sizeLastCheck = -1;
    protected transient int redstoneIn = 0;
    protected transient boolean didWork;

    public FunctionalFlowerBase(TileEntityType<?> tileEntityType, int color, boolean isGenerating) {
        super(tileEntityType);
        this.color = color;
        this.maxMana = 300;
        this.maxTransfer = isGenerating ? 30 : Integer.MAX_VALUE;
        this.isGenerating = isGenerating;
    }

    public FunctionalFlowerBase(TileEntityType<?> tileEntityType, int color, int maxMana, int maxTransfer, boolean isGenerating) {
        super(tileEntityType);
        this.color = color;
        this.maxMana = maxMana;
        this.maxTransfer = maxTransfer;
        this.isGenerating = isGenerating;
    }

    public final void func_73660_a() {
        boolean prevFloating = this.floating;
        this.floating = this.func_195044_w().func_177230_c() instanceof BlockFloatingFunctionalFlower;
        if (prevFloating != this.floating) {
            this.func_70296_d();
        }
        this.linkPool();
        if (!this.field_145850_b.field_72995_K) {
            int manaTransfer;
            if (this.isGenerating) {
                if (this.spreaderTile != null && this.mana > 0) {
                    manaTransfer = Math.min(this.maxTransfer, Math.min(this.mana, this.spreaderTile.getMaxMana() - this.spreaderTile.getCurrentMana()));
                    this.spreaderTile.receiveMana(manaTransfer);
                    this.mana = MathHelper.func_76125_a((int)(this.mana - manaTransfer), (int)0, (int)this.maxMana);
                    this.func_70296_d();
                    this.markPoolDirty();
                }
            } else if (this.poolTile != null && this.mana < this.maxMana) {
                manaTransfer = Math.min(this.maxTransfer, Math.min(this.maxMana - this.mana, this.poolTile.getCurrentMana()));
                this.poolTile.receiveMana(-manaTransfer);
                this.mana = MathHelper.func_76125_a((int)(this.mana + manaTransfer), (int)0, (int)this.maxMana);
                this.func_70296_d();
                this.markPoolDirty();
            }
            this.redstoneIn = 0;
            for (Direction dir : Direction.values()) {
                int redstonePower = this.field_145850_b.func_175651_c(this.func_174877_v().func_177972_a(dir), dir);
                this.redstoneIn = Math.max(redstonePower, this.redstoneIn);
            }
        }
        double particleChance = 1.0 - (double)this.mana / (double)this.maxMana / 3.5;
        this.didWork = false;
        this.tickFlower();
        if (this.field_145850_b.field_72995_K) {
            if (this.didWork) {
                particleChance = 3.0 * particleChance;
            }
            float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
            float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(this.color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                BotaniaAPI.instance().sparkleFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.func_174877_v().func_177956_o() + 0.5 + Math.random() * 0.5, (double)this.func_174877_v().func_177952_p() + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
    }

    protected abstract void tickFlower();

    public boolean canSelect(PlayerEntity player, ItemStack stack, BlockPos pos, Direction direction) {
        return true;
    }

    public boolean bindTo(PlayerEntity player, ItemStack stack, BlockPos pos, Direction direction) {
        int range = 10;
        double dist = pos.func_177951_i((Vector3i)this.func_174877_v());
        if ((double)(range *= range) >= dist) {
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (this.isGenerating && tile instanceof IManaCollector) {
                this.pool = tile.func_174877_v();
                this.spreaderTile = (IManaCollector)tile;
                this.poolTile = null;
                this.func_70296_d();
                return true;
            }
            if (!this.isGenerating && tile instanceof IManaPool) {
                this.pool = tile.func_174877_v();
                this.poolTile = (IManaPool)tile;
                this.spreaderTile = null;
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public BlockPos getBinding() {
        return this.pool;
    }

    public void linkPool() {
        IManaCollector theTileObj = this.isGenerating ? this.spreaderTile : this.poolTile;
        TileEntity theTile = !(theTileObj instanceof TileEntity) ? null : (TileEntity)theTileObj;
        if (this.pool != null && theTile == null || this.pool != null && !this.pool.equals((Object)theTile.func_174877_v()) || this.pool != null && this.field_145850_b.func_175625_s(this.pool) != theTile) {
            TileEntity te = this.field_145850_b.func_175625_s(this.pool);
            if (this.isGenerating) {
                if (!(te instanceof IManaCollector)) {
                    this.poolTile = null;
                    this.spreaderTile = null;
                } else {
                    this.poolTile = null;
                    this.spreaderTile = (IManaCollector)te;
                }
            } else {
                this.poolTile = !(te instanceof IManaPool) ? null : (IManaPool)te;
                this.spreaderTile = null;
            }
        }
        if (this.pool == null) {
            IManaNetwork network;
            if (this.isGenerating) {
                network = BotaniaAPI.instance().getManaNetworkInstance();
                int size = network.getAllCollectorsInWorld(this.func_145831_w()).size();
                if (BotaniaAPI.instance().shouldForceCheck() || size != this.sizeLastCheck) {
                    TileEntity te = network.getClosestCollector(this.func_174877_v(), this.func_145831_w(), 10);
                    if (te instanceof IManaCollector) {
                        this.pool = te.func_174877_v();
                        this.poolTile = null;
                        this.spreaderTile = (IManaCollector)te;
                        this.func_70296_d();
                    }
                    this.sizeLastCheck = size;
                }
            } else {
                network = BotaniaAPI.instance().getManaNetworkInstance();
                int size = network.getAllPoolsInWorld(this.func_145831_w()).size();
                if (BotaniaAPI.instance().shouldForceCheck() || size != this.sizeLastCheck) {
                    TileEntity te = network.getClosestPool(this.func_174877_v(), this.func_145831_w(), 10);
                    if (te instanceof IManaPool) {
                        this.pool = te.func_174877_v();
                        this.poolTile = (IManaPool)te;
                        this.spreaderTile = null;
                        this.func_70296_d();
                    }
                    this.sizeLastCheck = size;
                }
            }
        }
        this.func_70296_d();
    }

    public void func_230337_a_(@Nonnull BlockState stateIn, @Nonnull CompoundNBT nbtIn) {
        super.func_230337_a_(stateIn, nbtIn);
        this.mana = nbtIn.func_150297_b("mana", 3) ? MathHelper.func_76125_a((int)nbtIn.func_74762_e("mana"), (int)0, (int)this.maxMana) : 0;
        if (nbtIn.func_74764_b("pool")) {
            CompoundNBT poolTag = nbtIn.func_74775_l("pool");
            this.pool = new BlockPos(poolTag.func_74762_e("x"), poolTag.func_74762_e("y"), poolTag.func_74762_e("z"));
        } else {
            this.pool = null;
        }
        this.floating = nbtIn.func_74767_n("floating");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        compound.func_74768_a("mana", MathHelper.func_76125_a((int)this.mana, (int)0, (int)this.maxMana));
        if (this.pool != null) {
            CompoundNBT poolTag = new CompoundNBT();
            poolTag.func_74768_a("x", this.pool.func_177958_n());
            poolTag.func_74768_a("y", this.pool.func_177956_o());
            poolTag.func_74768_a("z", this.pool.func_177952_p());
            compound.func_218657_a("pool", (INBT)poolTag);
        }
        compound.func_74757_a("floating", this.floating);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (!this.field_145850_b.field_72995_K) {
            tag.func_74768_a("mana", MathHelper.func_76125_a((int)this.mana, (int)0, (int)this.maxMana));
            if (this.pool != null) {
                CompoundNBT poolTag = new CompoundNBT();
                poolTag.func_74768_a("x", this.pool.func_177958_n());
                poolTag.func_74768_a("y", this.pool.func_177956_o());
                poolTag.func_74768_a("z", this.pool.func_177952_p());
                tag.func_218657_a("pool", (INBT)poolTag);
            }
            tag.func_74757_a("floating", this.floating);
        }
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (this.field_145850_b.field_72995_K) {
            this.mana = MathHelper.func_76125_a((int)tag.func_74762_e("mana"), (int)0, (int)this.maxMana);
            if (tag.func_74764_b("pool")) {
                CompoundNBT poolTag = tag.func_74775_l("pool");
                this.pool = new BlockPos(poolTag.func_74762_e("x"), poolTag.func_74762_e("y"), poolTag.func_74762_e("z"));
            } else {
                this.pool = null;
            }
            this.floating = tag.func_74767_n("floating");
        }
    }

    public boolean isValidBinding() {
        IManaCollector theTileObj;
        Object object = theTileObj = this.isGenerating ? this.spreaderTile : this.poolTile;
        if (!(theTileObj instanceof TileEntity)) {
            return false;
        }
        TileEntity theTile = (TileEntity)theTileObj;
        return this.pool != null && theTile != null && theTile.func_145830_o() && !theTile.func_145837_r() && this.field_145850_b.func_175667_e(theTile.func_174877_v()) && this.func_145831_w().func_175625_s(this.pool) == theTile;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean floating) {
        this.floating = floating;
        this.func_70296_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public RadiusDescriptor getRadius() {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private void markPoolDirty() {
        if (this.poolTile instanceof TileEntity) {
            ((TileEntity)this.poolTile).func_70296_d();
        }
        if (this.spreaderTile instanceof TileEntity) {
            ((TileEntity)this.spreaderTile).func_70296_d();
        }
    }
}

