/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.recipes.builder;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.data.CraftingHelper2;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModRecipes;
import mythicbotany.rune.RuneRitualRecipe;
import mythicbotany.rune.SpecialRuneInput;
import mythicbotany.rune.SpecialRuneOutput;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RuneRitualRecipeBuilder {
    private final Ingredient centerRune;
    private final List<RuneRitualRecipe.RunePosition> runes = new ArrayList<RuneRitualRecipe.RunePosition>();
    private int manaCost = 0;
    private int tickTime = 200;
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();
    @Nullable
    private SpecialRuneInput specialInput;
    @Nullable
    private SpecialRuneOutput specialOutput;

    public static RuneRitualRecipeBuilder runeRitual(IItemProvider centerRune) {
        return new RuneRitualRecipeBuilder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{centerRune}));
    }

    public static RuneRitualRecipeBuilder runeRitual(ITag<Item> centerRune) {
        return new RuneRitualRecipeBuilder(Ingredient.func_199805_a(centerRune));
    }

    public static RuneRitualRecipeBuilder runeRitual(Ingredient centerRune) {
        return new RuneRitualRecipeBuilder(centerRune);
    }

    private RuneRitualRecipeBuilder(Ingredient centerRune) {
        this.centerRune = centerRune;
    }

    public RuneRitualRecipeBuilder rune(IItemProvider rune, int x, int z, boolean consume) {
        return this.rune(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{rune}), x, z, consume);
    }

    public RuneRitualRecipeBuilder rune(ITag<Item> rune, int x, int z, boolean consume) {
        return this.rune(Ingredient.func_199805_a(rune), x, z, consume);
    }

    public RuneRitualRecipeBuilder rune(Ingredient rune, int x, int z, boolean consume) {
        if (x < -5 || x > 5 || z < -5 || z > 5) {
            throw new IllegalStateException("Rune positions should not be more than 5 blocks away frm the master rune holder: (" + x + "," + z + ")");
        }
        this.runes.add(new RuneRitualRecipe.RunePosition(rune, x, z, consume));
        return this;
    }

    public RuneRitualRecipeBuilder rune4(IItemProvider rune, int x, int z, boolean consume) {
        if (x == 0) {
            this.rune(rune, 0, -z, consume);
            this.rune(rune, 0, z, consume);
            this.rune(rune, -z, 0, consume);
            this.rune(rune, z, 0, consume);
        } else if (z == 0) {
            this.rune(rune, -x, 0, consume);
            this.rune(rune, x, 0, consume);
            this.rune(rune, 0, -x, consume);
            this.rune(rune, 0, x, consume);
        } else {
            this.rune(rune, -x, -z, consume);
            this.rune(rune, -x, z, consume);
            this.rune(rune, x, -z, consume);
            this.rune(rune, x, z, consume);
        }
        return this;
    }

    public RuneRitualRecipeBuilder rune4(ITag<Item> rune, int x, int z, boolean consume) {
        if (x == 0) {
            this.rune(rune, 0, -z, consume);
            this.rune(rune, 0, z, consume);
            this.rune(rune, -z, 0, consume);
            this.rune(rune, z, 0, consume);
        } else if (z == 0) {
            this.rune(rune, -x, 0, consume);
            this.rune(rune, x, 0, consume);
            this.rune(rune, 0, -x, consume);
            this.rune(rune, 0, x, consume);
        } else {
            this.rune(rune, -x, -z, consume);
            this.rune(rune, -x, z, consume);
            this.rune(rune, x, -z, consume);
            this.rune(rune, x, z, consume);
        }
        return this;
    }

    public RuneRitualRecipeBuilder rune4(Ingredient rune, int x, int z, boolean consume) {
        if (x == 0) {
            this.rune(rune, 0, -z, consume);
            this.rune(rune, 0, z, consume);
            this.rune(rune, -z, 0, consume);
            this.rune(rune, z, 0, consume);
        } else if (z == 0) {
            this.rune(rune, -x, 0, consume);
            this.rune(rune, x, 0, consume);
            this.rune(rune, 0, -x, consume);
            this.rune(rune, 0, x, consume);
        } else {
            this.rune(rune, -x, -z, consume);
            this.rune(rune, -x, z, consume);
            this.rune(rune, x, -z, consume);
            this.rune(rune, x, z, consume);
        }
        return this;
    }

    public RuneRitualRecipeBuilder rune2(IItemProvider rune, int x, int z, boolean consume) {
        this.rune(rune, -x, -z, consume);
        this.rune(rune, x, z, consume);
        return this;
    }

    public RuneRitualRecipeBuilder rune2(ITag<Item> rune, int x, int z, boolean consume) {
        this.rune(rune, -x, -z, consume);
        this.rune(rune, x, z, consume);
        return this;
    }

    public RuneRitualRecipeBuilder rune2(Ingredient rune, int x, int z, boolean consume) {
        this.rune(rune, -x, -z, consume);
        this.rune(rune, x, z, consume);
        return this;
    }

    public RuneRitualRecipeBuilder rune(IItemProvider rune, int x, int z) {
        return this.rune(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune(ITag<Item> rune, int x, int z) {
        return this.rune(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune(Ingredient rune, int x, int z) {
        return this.rune(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune4(IItemProvider rune, int x, int z) {
        return this.rune4(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune4(ITag<Item> rune, int x, int z) {
        return this.rune4(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune4(Ingredient rune, int x, int z) {
        return this.rune4(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune2(IItemProvider rune, int x, int z) {
        return this.rune2(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune2(ITag<Item> rune, int x, int z) {
        return this.rune2(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder rune2(Ingredient rune, int x, int z) {
        return this.rune2(rune, x, z, false);
    }

    public RuneRitualRecipeBuilder mana(int manaCost) {
        this.manaCost = manaCost;
        return this;
    }

    public RuneRitualRecipeBuilder time(int tickTime) {
        this.tickTime = tickTime;
        return this;
    }

    public RuneRitualRecipeBuilder input(IItemProvider input) {
        return this.input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}));
    }

    public RuneRitualRecipeBuilder input(ITag<Item> input) {
        return this.input(Ingredient.func_199805_a(input));
    }

    public RuneRitualRecipeBuilder input(Ingredient input) {
        this.inputs.add(input);
        return this;
    }

    public RuneRitualRecipeBuilder output(IItemProvider output) {
        return this.output(new ItemStack(output));
    }

    public RuneRitualRecipeBuilder output(ItemStack output) {
        this.outputs.add(output);
        return this;
    }

    public RuneRitualRecipeBuilder special(@Nullable SpecialRuneInput special) {
        this.specialInput = special;
        return this;
    }

    public RuneRitualRecipeBuilder special(@Nullable SpecialRuneOutput special) {
        this.specialOutput = special;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation rl = null;
        if (this.outputs.size() == 1) {
            rl = this.outputs.get(0).func_77973_b().getRegistryName();
        } else if (this.specialOutput != null) {
            rl = this.specialOutput.id;
        }
        if (rl == null) {
            throw new IllegalStateException("Failed to infer recipe id for rune ritual recipe.w");
        }
        this.build(consumer, rl);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new FinishedRecipe(new ResourceLocation(id.func_110624_b(), "mythicbotany_rune_rituals/" + id.func_110623_a()), this.centerRune, this.runes, this.manaCost, this.tickTime, this.inputs, this.outputs, this.specialInput, this.specialOutput));
    }

    private static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient centerRune;
        private final List<RuneRitualRecipe.RunePosition> runes;
        private final int manaCost;
        private final int tickTime;
        private final List<Ingredient> inputs;
        private final List<ItemStack> outputs;
        @Nullable
        private final SpecialRuneInput specialInput;
        @Nullable
        private final SpecialRuneOutput specialOutput;

        private FinishedRecipe(ResourceLocation id, Ingredient centerRune, List<RuneRitualRecipe.RunePosition> runes, int manaCost, int tickTime, List<Ingredient> inputs, List<ItemStack> outputs, @Nullable SpecialRuneInput specialInput, @Nullable SpecialRuneOutput specialOutput) {
            this.id = id;
            this.centerRune = centerRune;
            this.runes = ImmutableList.copyOf(runes);
            this.manaCost = manaCost;
            this.tickTime = tickTime;
            this.inputs = ImmutableList.copyOf(inputs);
            this.outputs = ImmutableList.copyOf(outputs);
            this.specialInput = specialInput;
            this.specialOutput = specialOutput;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.addProperty("group", "rune_rituals");
            json.add("center", this.centerRune.func_200304_c());
            JsonArray runesJson = new JsonArray();
            this.runes.stream().map(rune -> {
                JsonObject obj = new JsonObject();
                obj.add("rune", rune.getRune().func_200304_c());
                obj.addProperty("x", (Number)rune.getX());
                obj.addProperty("z", (Number)rune.getZ());
                obj.addProperty("consume", Boolean.valueOf(rune.isConsumed()));
                return obj;
            }).forEach(arg_0 -> ((JsonArray)runesJson).add(arg_0));
            json.add("runes", (JsonElement)runesJson);
            json.addProperty("mana", (Number)this.manaCost);
            json.addProperty("ticks", (Number)this.tickTime);
            JsonArray inputsJson = new JsonArray();
            this.inputs.stream().map(Ingredient::func_200304_c).forEach(arg_0 -> ((JsonArray)inputsJson).add(arg_0));
            json.add("inputs", (JsonElement)inputsJson);
            JsonArray outputsJson = new JsonArray();
            this.outputs.stream().map(stack -> CraftingHelper2.serializeItemStack((ItemStack)stack, (boolean)true)).forEach(arg_0 -> ((JsonArray)outputsJson).add(arg_0));
            json.add("outputs", (JsonElement)outputsJson);
            if (this.specialInput != null) {
                json.addProperty("special_input", this.specialInput.id.toString());
            }
            if (this.specialOutput != null) {
                json.addProperty("special_output", this.specialOutput.id.toString());
            }
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipes.RUNE_RITUAL_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

