/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.base;

import com.google.common.base.Predicates;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

public abstract class TileEntityMana
extends TileEntityBase
implements ISparkAttachable,
IManaReceiver {
    public final int maxMana;
    private final boolean bursts;
    private final boolean sparks;
    protected int mana;

    public TileEntityMana(TileEntityType<?> tileEntityTypeIn, int maxMana, boolean bursts, boolean sparks) {
        super(tileEntityTypeIn);
        this.maxMana = maxMana;
        this.bursts = bursts;
        this.sparks = sparks;
    }

    protected abstract boolean canReceive();

    public boolean canAttachSpark(ItemStack itemStack) {
        return this.sparks;
    }

    public void attachSpark(ISparkEntity iSparkEntity) {
    }

    public int getAvailableSpaceForMana() {
        return MathHelper.func_76125_a((int)(this.maxMana - this.mana), (int)0, (int)this.maxMana);
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.mana < this.maxMana && this.canReceive();
    }

    public boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public void receiveMana(int i) {
        this.mana = MathHelper.func_76125_a((int)(this.mana + i), (int)0, (int)this.maxMana);
        this.onManaChange();
        this.func_70296_d();
    }

    public boolean canReceiveManaFromBursts() {
        return this.bursts;
    }

    public int getCurrentMana() {
        return MathHelper.func_76125_a((int)this.mana, (int)0, (int)this.maxMana);
    }

    public void func_230337_a_(@Nonnull BlockState stateIn, @Nonnull CompoundNBT nbtIn) {
        super.func_230337_a_(stateIn, nbtIn);
        this.mana = nbtIn.func_150297_b("mana", 3) ? MathHelper.func_76125_a((int)nbtIn.func_74762_e("mana"), (int)0, (int)this.maxMana) : 0;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        compound.func_74768_a("mana", MathHelper.func_76125_a((int)this.mana, (int)0, (int)this.maxMana));
        return super.func_189515_b(compound);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (!this.field_145850_b.field_72995_K) {
            tag.func_74768_a("mana", this.mana);
        }
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (this.field_145850_b.field_72995_K) {
            this.mana = MathHelper.func_76125_a((int)tag.func_74762_e("mana"), (int)0, (int)this.maxMana);
        }
    }

    protected void onManaChange() {
    }
}

