/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.pylon.PylonRepairable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelHelm;
import vazkii.botania.common.lib.ModTags;

public class AlfsteelHelm
extends ItemTerrasteelHelm
implements PylonRepairable {
    private static final float JUMP_FACTOR = 0.025f;
    private static final LazyValue<ItemStack[]> armorSet = new LazyValue(() -> new ItemStack[]{new ItemStack((IItemProvider)ModItems.alfsteelHelmet), new ItemStack((IItemProvider)ModItems.alfsteelChestplate), new ItemStack((IItemProvider)ModItems.alfsteelLeggings), new ItemStack((IItemProvider)ModItems.alfsteelBoots)});

    public AlfsteelHelm(Item.Properties props) {
        super(props.func_200918_c(5200));
        MinecraftForge.EVENT_BUS.addListener(this::onJump);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlotType slot) {
        return MythicBotany.getInstance().modid + ":textures/model/armor_alfsteel.png";
    }

    private void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() == ModItems.alfsteelBoots) {
            LivingEntity entity = event.getEntityLiving();
            float rot = entity.field_70177_z * ((float)Math.PI / 180);
            float xzFactor = entity.func_70051_ag() ? 0.025f : 0.0f;
            entity.func_213317_d(entity.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)rot) * xzFactor), (double)0.025f, (double)(MathHelper.func_76134_b((float)rot) * xzFactor)));
        }
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slot) {
        LinkedHashMultimap ret = LinkedHashMultimap.create((Multimap)super.func_111205_h(slot));
        ret.removeAll((Object)Attributes.field_233820_c_);
        if (slot == this.func_185083_B_()) {
            UUID uuid = new UUID(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this).hashCode() + slot.toString().hashCode(), 0L);
            if (this == ModItems.alfsteelHelmet) {
                Attribute reachDistance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("forge", "reach_distance"));
                if (reachDistance != null) {
                    ret.put((Object)reachDistance, (Object)new AttributeModifier(uuid, "Alfsteel modifier " + this.type, 2.0, AttributeModifier.Operation.ADDITION));
                }
            } else if (this == ModItems.alfsteelChestplate) {
                ret.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Alfsteel modifier " + this.type, 1.0, AttributeModifier.Operation.ADDITION));
            } else if (this == ModItems.alfsteelLeggings) {
                ret.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(uuid, "Alfsteel modifier " + this.type, 0.05, AttributeModifier.Operation.ADDITION));
                Attribute swimSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("forge", "swim_speed"));
                if (swimSpeed != null) {
                    UUID uuid2 = new UUID(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this).hashCode() + slot.toString().hashCode(), 1L);
                    ret.put((Object)swimSpeed, (Object)new AttributeModifier(uuid2, "Alfsteel modifier swim " + this.type, 0.05, AttributeModifier.Operation.ADDITION));
                }
            }
        }
        return ret;
    }

    public ItemStack[] getArmorSetStacks() {
        return (ItemStack[])armorSet.func_179281_c();
    }

    public boolean hasArmorSetItem(PlayerEntity player, EquipmentSlotType slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slot) {
            case HEAD: {
                return stack.func_77973_b() == ModItems.alfsteelHelmet;
            }
            case CHEST: {
                return stack.func_77973_b() == ModItems.alfsteelChestplate;
            }
            case LEGS: {
                return stack.func_77973_b() == ModItems.alfsteelLeggings;
            }
            case FEET: {
                return stack.func_77973_b() == ModItems.alfsteelBoots;
            }
        }
        return false;
    }

    public IFormattableTextComponent getArmorSetName() {
        return new TranslationTextComponent("botania.armorset.terrasteel.name");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        super.addArmorSetDescription(stack, list);
        if (stack.func_77973_b() == ModItems.alfsteelHelmet) {
            list.add((ITextComponent)new TranslationTextComponent("item.mythicbotany.alfsteel_helmet.description").func_240699_a_(TextFormatting.GOLD));
        } else if (stack.func_77973_b() == ModItems.alfsteelChestplate) {
            list.add((ITextComponent)new TranslationTextComponent("item.mythicbotany.alfsteel_chestplate.description").func_240699_a_(TextFormatting.GOLD));
        } else if (stack.func_77973_b() == ModItems.alfsteelLeggings) {
            list.add((ITextComponent)new TranslationTextComponent("item.mythicbotany.alfsteel_leggings.description").func_240699_a_(TextFormatting.GOLD));
        } else if (stack.func_77973_b() == ModItems.alfsteelBoots) {
            list.add((ITextComponent)new TranslationTextComponent("item.mythicbotany.alfsteel_boots.description").func_240699_a_(TextFormatting.GOLD));
        }
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.func_77973_b() == ModItems.alfsteelIngot || !Ingredient.func_199805_a((ITag)ModTags.Items.INGOTS_TERRASTEEL).test(repair) && super.func_82789_a(toRepair, repair);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return 500;
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.func_196085_b(Math.max(0, stack.func_77952_i() - 5));
        return stack;
    }
}

