/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mythicbotany.alfheim.AlfheimWorldGen;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.item.ModItems;

public class AbandonedApothecaryFeature
extends Feature<NoFeatureConfig> {
    private static final List<BlockState> STATES = ImmutableList.of((Object)ModBlocks.defaultAltar.func_176223_P(), (Object)ModBlocks.forestAltar.func_176223_P(), (Object)ModBlocks.plainsAltar.func_176223_P(), (Object)ModBlocks.mountainAltar.func_176223_P(), (Object)ModBlocks.fungalAltar.func_176223_P(), (Object)ModBlocks.swampAltar.func_176223_P(), (Object)ModBlocks.desertAltar.func_176223_P(), (Object)ModBlocks.taigaAltar.func_176223_P(), (Object)ModBlocks.mesaAltar.func_176223_P(), (Object)ModBlocks.mossyAltar.func_176223_P());
    private static final List<Item> PETALS = ImmutableList.of((Object)ModItems.whitePetal, (Object)ModItems.orangePetal, (Object)ModItems.magentaPetal, (Object)ModItems.lightBluePetal, (Object)ModItems.yellowPetal, (Object)ModItems.limePetal, (Object)ModItems.pinkPetal, (Object)ModItems.grayPetal, (Object)ModItems.lightGrayPetal, (Object)ModItems.cyanPetal, (Object)ModItems.purplePetal, (Object)ModItems.bluePetal, (Object[])new Item[]{ModItems.brownPetal, ModItems.greenPetal, ModItems.redPetal, ModItems.blackPetal});

    public AbandonedApothecaryFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(@Nonnull ISeedReader world, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        if (rand.nextInt(6) == 0) {
            return this.tryGenerate(world, generator, rand, new BlockPos(pos.func_177958_n() + rand.nextInt(16), 0, pos.func_177952_p() + rand.nextInt(16)));
        }
        return false;
    }

    private boolean tryGenerate(@Nonnull ISeedReader world, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos hor) {
        BlockPos pos = AlfheimWorldGen.highestFreeBlock(world, hor, AlfheimWorldGen::passReplaceableAndLeaves);
        if (world.func_180495_p(pos.func_177977_b()).func_200132_m() && world.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            BlockState state = STATES.get(rand.nextInt(STATES.size()));
            if (rand.nextInt(30) == 0) {
                return world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.LAVA), 2);
            }
            if (rand.nextInt(4) != 0) {
                if (!world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.WATER), 2)) {
                    return false;
                }
                try {
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof TileAltar) {
                        te.func_174878_a(pos);
                        te.field_195045_e = (BlockState)state.func_206870_a((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.WATER);
                        int petals = rand.nextInt(5);
                        for (int i = 0; i < petals; ++i) {
                            ((TileAltar)te).getItemHandler().func_70299_a(i, new ItemStack((IItemProvider)PETALS.get(rand.nextInt(PETALS.size()))));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            return world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockAltar.FLUID, (Comparable)IPetalApothecary.State.EMPTY), 2);
        }
        return false;
    }
}

