/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.phosphophyllite.data.DataLoader;

public class ReactorModeratorRegistry {
    public static final IModeratorProperties EMPTY_MODERATOR = new IModeratorProperties(){

        @Override
        public double absorption() {
            return 0.0;
        }

        @Override
        public double heatEfficiency() {
            return 0.0;
        }

        @Override
        public double moderation() {
            return 1.0;
        }

        @Override
        public double heatConductivity() {
            return 0.0;
        }
    };
    private static final HashMap<Block, ModeratorProperties> registry = new HashMap();
    private static final DataLoader<ReactorModeratorJsonData> dataLoader = new DataLoader(ReactorModeratorJsonData.class);

    public static Map<Block, ModeratorProperties> getImmutableRegistry() {
        return Collections.unmodifiableMap(registry);
    }

    public static boolean isBlockAllowed(Block block) {
        return registry.containsKey(block);
    }

    public static ModeratorProperties blockModeratorProperties(Block block) {
        return registry.get(block);
    }

    public static void loadRegistry(ITagCollectionSupplier tags) {
        ITagCollection blockTags = tags.func_241835_a();
        ITagCollection fluidTags = tags.func_241837_c();
        BiggerReactors.LOGGER.info("Loading reactor moderators");
        registry.clear();
        List data = dataLoader.loadAll(new ResourceLocation("biggerreactors:ebcr/moderators"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " moderator data entries");
        for (ReactorModeratorJsonData moderatorData : data) {
            ModeratorProperties properties = new ModeratorProperties(moderatorData.absorption, moderatorData.efficiency, moderatorData.moderation, moderatorData.conductivity);
            switch (moderatorData.type) {
                case "tag": {
                    ITag blockTag = blockTags.func_199910_a(moderatorData.location);
                    if (blockTag == null) break;
                    for (Block element : blockTag.func_230236_b_()) {
                        registry.put(element, properties);
                        BiggerReactors.LOGGER.debug("Loaded moderator " + element.getRegistryName().toString());
                    }
                    break;
                }
                case "registry": {
                    if (!ForgeRegistries.BLOCKS.containsKey(moderatorData.location)) break;
                    registry.put((Block)ForgeRegistries.BLOCKS.getValue(moderatorData.location), properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + moderatorData.location);
                    break;
                }
                case "fluidtag": {
                    ITag blockTag = fluidTags.func_199910_a(moderatorData.location);
                    if (blockTag == null) break;
                    for (Block element : blockTag.func_230236_b_()) {
                        Block elementBlock = element.func_207188_f().func_206883_i().func_177230_c();
                        registry.put(elementBlock, properties);
                        BiggerReactors.LOGGER.debug("Loaded moderator " + element.getRegistryName().toString());
                    }
                    break;
                }
                case "fluid": {
                    if (!ForgeRegistries.FLUIDS.containsKey(moderatorData.location)) break;
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(moderatorData.location);
                    assert (fluid != null);
                    Block block = fluid.func_207188_f().func_206883_i().func_177230_c();
                    registry.put(block, properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + moderatorData.location);
                }
            }
        }
        BiggerReactors.LOGGER.info("Loaded " + registry.size() + " moderator entries");
    }

    private static class ReactorModeratorJsonData {
        @DataLoader.Values(value={"tag", "registry", "fluidtag", "fluid"})
        String type;
        ResourceLocation location;
        @DataLoader.Range(value="[0,1]")
        double absorption;
        @DataLoader.Range(value="[0,1]")
        double efficiency;
        @DataLoader.Range(value="[1,)")
        double moderation;
        @DataLoader.Range(value="[0,)")
        double conductivity;

        private ReactorModeratorJsonData() {
        }
    }

    public static class ModeratorProperties
    implements IModeratorProperties {
        public final double absorption;
        public final double heatEfficiency;
        public final double moderation;
        public final double heatConductivity;

        public ModeratorProperties(double absorption, double heatEfficiency, double moderation, double heatConductivity) {
            this.absorption = absorption;
            this.heatEfficiency = heatEfficiency;
            this.moderation = moderation;
            this.heatConductivity = heatConductivity;
        }

        @Override
        public double absorption() {
            return this.absorption;
        }

        @Override
        public double heatEfficiency() {
            return this.heatEfficiency;
        }

        @Override
        public double moderation() {
            return this.moderation;
        }

        @Override
        public double heatConductivity() {
            return this.heatConductivity;
        }
    }

    public static interface IModeratorProperties {
        public double absorption();

        public double heatEfficiency();

        public double moderation();

        public double heatConductivity();
    }
}

