/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.tiles;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.multiblocks.turbine.TurbineMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.multiblock.generic.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;

@RegisterTileEntity(name="turbine_rotor_bearing")
public class TurbineRotorBearingTile
extends TurbineBaseTile
implements IAssemblyAttemptedTile {
    @RegisterTileEntity.Type
    public static TileEntityType<TurbineRotorBearingTile> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    public double angle = 0.0;
    public boolean isRenderBearing = false;
    public double speed = 0.0;
    public Vector3f rotationAxis = null;
    public ArrayList<Vector4i> rotorConfiguration = null;
    public AxisAlignedBB AABB = null;
    private long sendFullUpdate = 0L;

    public TurbineRotorBearingTile() {
        super(TYPE);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.controller != null) {
            nbt.func_74780_a("speed", ((TurbineMultiblockController)this.controller).simulation().RPM());
            if (this.sendFullUpdate >= Phosphophyllite.tickNumber()) {
                this.sendFullUpdate = Long.MAX_VALUE;
                nbt.func_218657_a("config", (INBT)this.func_189517_E_());
            }
        }
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        if (nbt.func_74764_b("speed")) {
            this.speed = nbt.func_74769_h("speed");
            if (nbt.func_74764_b("config")) {
                this.handleUpdateTag(this.func_195044_w(), nbt.func_74775_l("config"));
            }
        }
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        if (nbt.func_74764_b("rotx")) {
            this.isRenderBearing = true;
            if (this.rotationAxis == null) {
                this.rotationAxis = new Vector3f();
            }
            this.rotationAxis.func_195905_a(nbt.func_74760_g("rotx"), nbt.func_74760_g("roty"), nbt.func_74760_g("rotz"));
            if (this.rotorConfiguration == null) {
                this.rotorConfiguration = new ArrayList();
            }
            this.rotorConfiguration.clear();
            int rotorShafts = nbt.func_74762_e("shafts");
            for (int i = 0; i < rotorShafts; ++i) {
                Vector4i vec = new Vector4i();
                vec.x = nbt.func_74762_e("shaft" + i + "0");
                vec.y = nbt.func_74762_e("shaft" + i + "1");
                vec.z = nbt.func_74762_e("shaft" + i + "2");
                vec.w = nbt.func_74762_e("shaft" + i + "3");
                this.rotorConfiguration.add(vec);
            }
            this.AABB = new AxisAlignedBB((double)nbt.func_74762_e("minx"), (double)nbt.func_74762_e("miny"), (double)nbt.func_74762_e("minz"), (double)nbt.func_74762_e("maxx"), (double)nbt.func_74762_e("maxy"), (double)nbt.func_74762_e("maxz"));
        } else {
            this.isRenderBearing = false;
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.isRenderBearing && this.controller != null) {
            nbt.func_74776_a("rotx", (float)((TurbineMultiblockController)this.controller).rotationAxis.func_177958_n());
            nbt.func_74776_a("roty", (float)((TurbineMultiblockController)this.controller).rotationAxis.func_177956_o());
            nbt.func_74776_a("rotz", (float)((TurbineMultiblockController)this.controller).rotationAxis.func_177952_p());
            nbt.func_74768_a("minx", ((TurbineMultiblockController)this.controller).minCoord().x());
            nbt.func_74768_a("miny", ((TurbineMultiblockController)this.controller).minCoord().y());
            nbt.func_74768_a("minz", ((TurbineMultiblockController)this.controller).minCoord().z());
            nbt.func_74768_a("maxx", ((TurbineMultiblockController)this.controller).maxCoord().x());
            nbt.func_74768_a("maxy", ((TurbineMultiblockController)this.controller).maxCoord().y());
            nbt.func_74768_a("maxz", ((TurbineMultiblockController)this.controller).maxCoord().z());
            nbt.func_74768_a("shafts", ((TurbineMultiblockController)this.controller).rotorConfiguration.size());
            ArrayList<Vector4i> config = ((TurbineMultiblockController)this.controller).rotorConfiguration;
            for (int i = 0; i < config.size(); ++i) {
                Vector4i vec = config.get(i);
                nbt.func_74768_a("shaft" + i + "0", vec.x);
                nbt.func_74768_a("shaft" + i + "1", vec.y);
                nbt.func_74768_a("shaft" + i + "2", vec.z);
                nbt.func_74768_a("shaft" + i + "3", vec.w);
            }
        }
        return nbt;
    }

    public void onAssemblyAttempted() {
        assert (this.field_145850_b != null);
        this.sendFullUpdate = Phosphophyllite.tickNumber() + 5L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.AABB == null) {
            return INFINITE_EXTENT_AABB;
        }
        return this.AABB;
    }

    static {
        SUPPLIER = TurbineRotorBearingTile::new;
    }
}

