/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.simulation.classic;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineBattery;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineFluidTank;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.classic.Battery;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.classic.FluidTank;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;

public class ClassicTurbineSimulation
implements ITurbineSimulation {
    private int x;
    private int y;
    private int z;
    private boolean active = false;
    private int rotorShafts;
    private long rotorMass;
    private long bladeSurfaceArea;
    private long coilSize;
    private double inductionEfficiency;
    private double inductorDragCoefficient;
    private double inductionEnergyExponentBonus;
    private double frictionDrag;
    private double bladeDrag;
    private double energyGeneratedLastTick;
    private double rotorEfficiencyLastTick;
    private double rotorEnergy = 0.0;
    private long maxFlowRate = 0L;
    private long maxMaxFlowRate = 0L;
    private VentState ventState = VentState.OVERFLOW;
    private boolean coilEngaged = true;
    private final Battery battery = new Battery();
    private final FluidTank fluidTank = new FluidTank();

    @Override
    public void reset() {
        this.rotorEnergy = 0.0;
        this.maxFlowRate = Config.Turbine.Classic.FluidPerBlade * this.bladeSurfaceArea;
    }

    @Override
    public void resize(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.coilSize = 0L;
        this.inductionEfficiency = 0.0;
        this.inductorDragCoefficient = 0.0;
        this.inductionEnergyExponentBonus = 0.0;
        this.maxMaxFlowRate = ((long)x * (long)z - 1L) * Config.Turbine.Classic.FlowRatePerBlock;
    }

    @Override
    public void setRotorConfiguration(ArrayList<Vector4i> rotorConfiguration) {
        this.rotorMass = 0L;
        this.bladeSurfaceArea = 0L;
        this.rotorMass += (long)rotorConfiguration.size();
        for (Vector4i vector4i : rotorConfiguration) {
            this.bladeSurfaceArea += (long)(vector4i.x + vector4i.y + vector4i.z + vector4i.w);
        }
        this.rotorMass += this.bladeSurfaceArea;
        this.rotorMass *= Config.Turbine.Classic.RotorMassPerPart;
        this.rotorShafts = rotorConfiguration.size();
    }

    @Override
    public void setCoilData(int x, int y, TurbineCoilRegistry.CoilData coilData) {
        this.inductionEfficiency += coilData.efficiency;
        this.inductionEnergyExponentBonus += coilData.bonus;
        double distance = Math.max(Math.abs(x), Math.abs(y));
        this.inductorDragCoefficient += coilData.extractionRate / distance;
        ++this.coilSize;
    }

    @Override
    public void updateInternalValues() {
        this.inductorDragCoefficient *= Config.Turbine.Classic.CoilDragMultiplier;
        this.frictionDrag = (double)this.rotorMass * Config.Turbine.Classic.MassDragMultiplier;
        this.bladeDrag = Config.Turbine.Classic.BladeDragMultiplier * (double)this.bladeSurfaceArea;
        this.battery.setCapacity((this.coilSize + 1L) * Config.Turbine.Classic.BatterySizePerCoilBlock);
        if (this.coilSize <= 0L) {
            this.inductionEfficiency = 0.0;
            this.inductorDragCoefficient = 0.0;
            this.inductionEnergyExponentBonus = 0.0;
        } else {
            this.inductionEfficiency = this.inductionEfficiency * 1.0 / (double)this.coilSize;
            this.inductionEnergyExponentBonus = Math.max(1.0, this.inductionEnergyExponentBonus / (double)this.coilSize);
            this.inductorDragCoefficient /= (double)this.coilSize;
        }
        this.fluidTank.perSideCapacity = ((long)this.x * (long)this.y * (long)this.z - ((long)this.rotorShafts + this.coilSize)) * Config.Turbine.Classic.TankVolumePerBlock;
    }

    @Override
    public void setVentState(VentState state) {
        this.ventState = state;
    }

    @Override
    public VentState ventState() {
        return this.ventState;
    }

    @Override
    public double RPM() {
        return this.bladeSurfaceArea > 0L && this.rotorMass > 0L ? this.rotorEnergy / (double)(this.bladeSurfaceArea * this.rotorMass) : 0.0;
    }

    @Override
    public double bladeEfficiencyLastTick() {
        return this.rotorEfficiencyLastTick;
    }

    @Override
    public long flowLastTick() {
        return this.fluidTank.transitionedLastTick();
    }

    @Override
    public long nominalFlowRate() {
        return this.maxFlowRate;
    }

    @Override
    public void setNominalFlowRate(long flowRate) {
        this.maxFlowRate = flowRate;
        this.maxFlowRate = Math.min(this.maxMaxFlowRate, Math.max(0L, flowRate));
    }

    @Override
    public long flowRateLimit() {
        return this.maxMaxFlowRate;
    }

    @Override
    public ITurbineBattery battery() {
        return this.battery;
    }

    @Override
    public ITurbineFluidTank fluidTank() {
        return this.fluidTank;
    }

    @Override
    public void tick() {
        this.energyGeneratedLastTick = 0.0;
        this.rotorEfficiencyLastTick = 0.0;
        long steamIn = 0L;
        if (this.active) {
            steamIn = Math.min(this.maxFlowRate, this.fluidTank.vaporAmount());
            if (this.ventState == VentState.CLOSED) {
                long availableSpace = this.fluidTank.perSideCapacity - this.fluidTank.liquidAmount();
                steamIn = Math.min(steamIn, availableSpace);
            }
        }
        if (steamIn > 0L || this.rotorEnergy > 0.0) {
            double inductionTorque;
            double energyToGenerate;
            double rotorSpeed = 0.0;
            if (this.bladeSurfaceArea > 0L && this.rotorMass > 0L) {
                rotorSpeed = this.rotorEnergy / (double)(this.bladeSurfaceArea * this.rotorMass);
            }
            double aeroDragTorque = rotorSpeed * this.bladeDrag;
            double liftTorque = 0.0;
            if (steamIn > 0L) {
                long steamToProcess = this.bladeSurfaceArea * Config.Turbine.Classic.FluidPerBlade;
                steamToProcess = Math.min(steamToProcess, steamIn);
                liftTorque = steamToProcess;
                if (steamToProcess < steamIn) {
                    steamToProcess = steamIn - steamToProcess;
                    double neededBlades = (double)steamIn / (double)Config.Turbine.Classic.FluidPerBlade;
                    double missingBlades = neededBlades - (double)this.bladeSurfaceArea;
                    double bladeEfficiency = 1.0 - missingBlades / neededBlades;
                    liftTorque += (double)steamToProcess * bladeEfficiency;
                }
                this.rotorEfficiencyLastTick = liftTorque / (double)steamIn;
                liftTorque *= this.fluidTank.activeTransition().turbineMultiplier * this.fluidTank.activeTransition().latentHeat;
            }
            if ((energyToGenerate = Math.pow(inductionTorque = this.coilEngaged ? rotorSpeed * this.inductorDragCoefficient * (double)this.coilSize : 0.0, this.inductionEnergyExponentBonus) * this.inductionEfficiency) > 0.0) {
                double efficiency = 0.25 * Math.cos(rotorSpeed / 142.94246573833559) + 0.75;
                if (rotorSpeed < 450.0) {
                    efficiency = Math.min(0.5, efficiency);
                }
                if (rotorSpeed > 2245.0) {
                    efficiency = -rotorSpeed / 4490.0;
                    efficiency += 1.0;
                }
                if (efficiency < 0.0) {
                    efficiency = 0.0;
                }
                this.energyGeneratedLastTick = energyToGenerate *= efficiency;
                this.battery.generate((long)energyToGenerate);
            }
            this.rotorEnergy += liftTorque;
            this.rotorEnergy -= inductionTorque;
            this.rotorEnergy -= aeroDragTorque;
            this.rotorEnergy -= this.frictionDrag;
            if (this.rotorEnergy < 0.0) {
                this.rotorEnergy = 0.0;
            }
            this.fluidTank.flow(steamIn, this.ventState != VentState.CLOSED);
            if (this.ventState == VentState.ALL) {
                this.fluidTank.dumpLiquid();
            }
        }
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void setCoilEngaged(boolean engaged) {
        this.coilEngaged = engaged;
    }

    @Override
    public boolean coilEngaged() {
        return this.coilEngaged;
    }

    @Override
    public long FEGeneratedLastTick() {
        return (long)this.energyGeneratedLastTick;
    }

    @Override
    public long bladeSurfaceArea() {
        return this.bladeSurfaceArea;
    }

    @Override
    public double rotorMass() {
        return this.rotorMass;
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public String debugString() {
        return "rotorMass: " + this.rotorMass + "\nbladeSurfaceArea: " + this.bladeSurfaceArea + "\ncoilSize: " + this.coilSize + "\ninductionEfficiency: " + this.inductionEfficiency + "\ninductorDragCoefficient: " + this.inductorDragCoefficient + "\ninductionEnergyExponentBonus: " + this.inductionEnergyExponentBonus + "\nfrictionDrag: " + this.frictionDrag + "\nbladeDrag: " + this.bladeDrag + "\nCoilEngaged: " + this.coilEngaged + " \nVentState: " + (Object)((Object)this.ventState) + " \nActive: " + this.active + " \nStoredPower: " + this.battery.stored() + "\nEnergyCapacity: " + this.battery.capacity() + "\nCoilEngaged: " + this.coilEngaged + " \nPowerProduction: " + this.energyGeneratedLastTick + "\nCoilEfficiency: " + this.rotorEfficiencyLastTick + "\nVaporAmount: " + this.fluidTank.vaporAmount() + "\nVaporType: " + this.fluidTank.vaporType() + "\nLiquidAmount: " + this.fluidTank.liquidAmount() + "\nLiquidType: " + this.fluidTank.liquidType() + "\nFlow: " + this.fluidTank.transitionedLastTick() + "\nRotorEfficiency: " + this.rotorEfficiencyLastTick + "\nMaxFlow: " + this.maxFlowRate + "\nRotorRPM: " + this.RPM() + "\n";
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("fluidTank", (INBT)this.fluidTank.serializeNBT());
        nbt.func_218657_a("battery", (INBT)this.battery.serializeNBT());
        nbt.func_74768_a("ventState", this.ventState.toInt());
        nbt.func_74780_a("rotorEnergy", this.rotorEnergy);
        nbt.func_74772_a("maxFlowRate", this.maxFlowRate);
        nbt.func_74757_a("coilEngaged", this.coilEngaged);
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.fluidTank.deserializeNBT(nbt.func_74775_l("fluidTank"));
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.ventState = VentState.fromInt(nbt.func_74762_e("ventState"));
        this.rotorEnergy = nbt.func_74769_h("rotorEnergy");
        this.maxFlowRate = nbt.func_74763_f("maxFlowRate");
        this.coilEngaged = nbt.func_74767_n("coilEngaged");
        this.active = nbt.func_74767_n("active");
    }
}

