/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic;

import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorCoolantTank;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;

public class CoolantTank
extends FluidTransitionTank
implements IReactorCoolantTank,
ReactorModeratorRegistry.IModeratorProperties {
    private ReactorModeratorRegistry.IModeratorProperties airProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;
    private ReactorModeratorRegistry.IModeratorProperties liquidProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;
    private ReactorModeratorRegistry.IModeratorProperties vaporProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;

    public CoolantTank() {
        super(false);
        this.transitionUpdate();
    }

    double absorbHeat(double rfTransferred) {
        long amountVaporized;
        this.transitionedLastTick = 0L;
        if (this.inAmount <= 0L || rfTransferred <= 0.0) {
            return rfTransferred;
        }
        this.maxTransitionedLastTick = amountVaporized = (long)(rfTransferred / this.activeTransition.latentHeat);
        amountVaporized = Math.min(this.inAmount, amountVaporized);
        if ((amountVaporized = Math.min(amountVaporized, this.perSideCapacity - this.outAmount)) < 1L) {
            return rfTransferred;
        }
        this.transitionedLastTick = amountVaporized;
        this.inAmount -= amountVaporized;
        this.outAmount += amountVaporized;
        double energyUsed = (double)amountVaporized * this.activeTransition.latentHeat;
        return Math.max(0.0, rfTransferred - energyUsed);
    }

    public double getCoolantTemperature(double reactorHeat) {
        if (this.inAmount <= 0L) {
            return reactorHeat;
        }
        return Math.min(reactorHeat, this.activeTransition.boilingPoint - 273.15);
    }

    @Override
    @Nonnull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74772_a("perSideCapacity", this.perSideCapacity);
        return nbt;
    }

    @Override
    public void deserializeNBT(@Nonnull CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.perSideCapacity = nbt.func_74763_f("perSideCapacity");
    }

    @Override
    public void dumpLiquid() {
        this.dumpTank(0);
    }

    @Override
    public void dumpVapor() {
        this.dumpTank(1);
    }

    @Override
    protected void transitionUpdate() {
        Fluid vapor;
        this.airProperties = ReactorModeratorRegistry.blockModeratorProperties(Blocks.field_150350_a);
        if (this.airProperties == null) {
            this.airProperties = ReactorModeratorRegistry.EMPTY_MODERATOR;
        }
        this.liquidProperties = this.airProperties;
        this.vaporProperties = this.airProperties;
        Fluid liquid = this.inFluid;
        if (liquid != null) {
            this.liquidProperties = ReactorModeratorRegistry.blockModeratorProperties(liquid.func_207188_f().func_206883_i().func_177230_c());
            if (this.liquidProperties == null) {
                this.liquidProperties = this.airProperties;
            }
        }
        if ((vapor = this.inFluid) != null) {
            this.vaporProperties = ReactorModeratorRegistry.blockModeratorProperties(vapor.func_207188_f().func_206883_i().func_177230_c());
            if (this.vaporProperties == null) {
                this.vaporProperties = this.airProperties;
            }
        }
    }

    @Override
    public double absorption() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.absorption();
        }
        double absorption = 0.0;
        absorption += this.airProperties.absorption() * (double)(this.perSideCapacity * 2L - (this.inAmount + this.outAmount));
        absorption += this.liquidProperties.absorption() * (double)this.inAmount;
        absorption += this.vaporProperties.absorption() * (double)this.outAmount;
        return absorption /= (double)(this.perSideCapacity * 2L);
    }

    @Override
    public double heatEfficiency() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.heatEfficiency();
        }
        double heatEfficiency = 0.0;
        heatEfficiency += this.airProperties.heatEfficiency() * (double)(this.perSideCapacity * 2L - (this.inAmount + this.outAmount));
        heatEfficiency += this.liquidProperties.heatEfficiency() * (double)this.inAmount;
        heatEfficiency += this.vaporProperties.heatEfficiency() * (double)this.outAmount;
        return heatEfficiency /= (double)(this.perSideCapacity * 2L);
    }

    @Override
    public double moderation() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.moderation();
        }
        double moderation = 0.0;
        moderation += this.airProperties.moderation() * (double)(this.perSideCapacity * 2L - (this.inAmount + this.outAmount));
        moderation += this.liquidProperties.moderation() * (double)this.inAmount;
        moderation += this.vaporProperties.moderation() * (double)this.outAmount;
        return moderation /= (double)(this.perSideCapacity * 2L);
    }

    @Override
    public double heatConductivity() {
        if (this.perSideCapacity == 0L) {
            return this.airProperties.heatConductivity();
        }
        double heatConductivity = 0.0;
        heatConductivity += this.airProperties.heatConductivity() * (double)(this.perSideCapacity * 2L - (this.inAmount + this.outAmount));
        heatConductivity += this.liquidProperties.heatConductivity() * (double)this.inAmount;
        heatConductivity += this.vaporProperties.heatConductivity() * (double)this.outAmount;
        return heatConductivity /= (double)(this.perSideCapacity * 2L);
    }
}

