/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ActiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;
import net.roguelogix.phosphophyllite.gui.client.elements.Tooltip;

@OnlyIn(value=Dist.CLIENT)
public class PassiveReactorTerminalScreen
extends ScreenBase<ReactorTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_terminal_passive.png");
    private ReactorState reactorState = (ReactorState)((ReactorTerminalContainer)this.func_212873_a_()).getGuiPacket();

    public PassiveReactorTerminalScreen(ReactorTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title, DEFAULT_TEXTURE, 176, 152);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        CommonReactorTerminalScreen.initTooltips(this, this.reactorState);
        this.initTooltips();
        CommonReactorTerminalScreen.initControls(this, this.reactorState);
        CommonReactorTerminalScreen.initGauges(this, this.reactorState);
        this.initGauges();
        CommonReactorTerminalScreen.initSymbols(this, this.reactorState);
    }

    private void initTooltips() {
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 8, 38, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.energy_generation_rate.tooltip")));
        Tooltip generationRateReadoutTooltip = new Tooltip((ScreenBase)this, 26, 38, 53, 16, StringTextComponent.field_240750_d_);
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = new StringTextComponent(String.format("%.3f RF/t", this.reactorState.reactorOutputRate));
        };
        this.addElement((AbstractElement)generationRateReadoutTooltip);
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 152, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.internal_battery.tooltip")));
    }

    private void initGauges() {
        Symbol internalBattery = new Symbol((ScreenBase)this, 151, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        internalBattery.onRender = (mS, mX, mY) -> CommonRender.renderEnergyGauge(mS, internalBattery, this.reactorState.energyStored, this.reactorState.energyCapacity);
        this.addElement((AbstractElement)internalBattery);
    }

    public void func_231023_e_() {
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.func_212873_a_()).getGuiPacket();
        super.func_231023_e_();
        if (this.reactorState.reactorType != ReactorType.PASSIVE) {
            this.getMinecraft().func_147108_a((Screen)new ActiveReactorTerminalScreen((ReactorTerminalContainer)this.field_147002_h, this.field_213127_e, this.field_230704_d_));
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        CommonReactorTerminalScreen.renderStatusText(mStack, this, this.reactorState.reactorActivity, this.reactorState.doAutoEject, this.reactorState.fuelHeatStored, this.reactorState.fuelUsageRate, this.reactorState.reactivityRate);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)this.reactorState.reactorOutputRate, (String)"RF/t"), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 42), 0x404040);
    }
}

