/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.gui.container.HeatExchangerTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.state.HeatExchangerState;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;
import net.roguelogix.phosphophyllite.gui.client.elements.Tooltip;

@OnlyIn(value=Dist.CLIENT)
public class HeatExchangerTerminalScreen
extends ScreenBase<HeatExchangerTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/heat_exchanger_terminal.png");
    private HeatExchangerState heatExchangerState;
    private Fluid condenserIntakeFluid = Fluids.field_204541_a;
    private Fluid condenserExhaustFluid = Fluids.field_204541_a;
    private Fluid evaporatorIntakeFluid = Fluids.field_204541_a;
    private Fluid evaporatorExhaustFluid = Fluids.field_204541_a;

    public HeatExchangerTerminalScreen(HeatExchangerTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal"), DEFAULT_TEXTURE, 144, 144);
        this.heatExchangerState = (HeatExchangerState)((HeatExchangerTerminalContainer)this.func_212873_a_()).getGuiPacket();
        this.condenserIntakeFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.condenserIntakeFluid));
        this.condenserExhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.condenserExhaustFluid));
        this.evaporatorIntakeFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.evaporatorIntakeFluid));
        this.evaporatorExhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.evaporatorExhaustFluid));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = this.getWidth() / 2 - this.getFont().func_238414_a_((ITextProperties)this.func_231171_q_()) / 2;
        this.initTooltips();
        this.initGauges();
    }

    private void initTooltips() {
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 9, 103, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.temperature.condenser.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 9, 122, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.temperature.evaporator.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 75, 103, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.flow_rate.condenser.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 75, 122, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.flow_rate.evaporator.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 9, 17, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.intake_gauge.condenser.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 31, 17, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.intake_gauge.evaporator.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 53, 17, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.temperature.condenser.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 75, 17, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.temperature.evaporator.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 97, 17, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.exhaust_gauge.condenser.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 119, 17, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.heat_exchanger_terminal.exhaust_gauge.evaporator.tooltip")));
    }

    private void initGauges() {
        Symbol condenserIntakeTank = new Symbol((ScreenBase)this, 8, 36, 18, 64, 0, 144, StringTextComponent.field_240750_d_);
        condenserIntakeTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, condenserIntakeTank, this.heatExchangerState.condenserIntakeFluidAmount, this.heatExchangerState.condenserTankSize, this.condenserIntakeFluid);
        this.addElement((AbstractElement)condenserIntakeTank);
        Symbol evaporatorIntakeTank = new Symbol((ScreenBase)this, 30, 36, 18, 64, 0, 144, StringTextComponent.field_240750_d_);
        evaporatorIntakeTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, evaporatorIntakeTank, this.heatExchangerState.evaporatorIntakeFluidAmount, this.heatExchangerState.evaporatorTankSize, this.evaporatorIntakeFluid);
        this.addElement((AbstractElement)evaporatorIntakeTank);
        Symbol condenserHeatGauge = new Symbol((ScreenBase)this, 52, 36, 18, 64, 0, 144, StringTextComponent.field_240750_d_);
        condenserHeatGauge.onRender = (mS, mX, mY) -> HeatExchangerTerminalScreen.renderHeatGauge(mS, (Symbol<HeatExchangerTerminalContainer>)condenserHeatGauge, this.heatExchangerState.condenserChannelTemperature, Config.HeatExchanger.GUI.HeatDisplayMax);
        this.addElement((AbstractElement)condenserHeatGauge);
        Symbol evaporatorHeatGauge = new Symbol((ScreenBase)this, 74, 36, 18, 64, 0, 144, StringTextComponent.field_240750_d_);
        evaporatorHeatGauge.onRender = (mS, mX, mY) -> HeatExchangerTerminalScreen.renderHeatGauge(mS, (Symbol<HeatExchangerTerminalContainer>)evaporatorHeatGauge, this.heatExchangerState.evaporatorChannelTemperature, Config.HeatExchanger.GUI.HeatDisplayMax);
        this.addElement((AbstractElement)evaporatorHeatGauge);
        Symbol condenserExhaustTank = new Symbol((ScreenBase)this, 96, 36, 18, 64, 0, 144, StringTextComponent.field_240750_d_);
        condenserExhaustTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, condenserExhaustTank, this.heatExchangerState.condenserExhaustFluidAmount, this.heatExchangerState.condenserTankSize, this.condenserExhaustFluid);
        this.addElement((AbstractElement)condenserExhaustTank);
        Symbol evaporatorExhaustTank = new Symbol((ScreenBase)this, 118, 36, 18, 64, 0, 144, StringTextComponent.field_240750_d_);
        evaporatorExhaustTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, evaporatorExhaustTank, this.heatExchangerState.evaporatorExhaustFluidAmount, this.heatExchangerState.evaporatorTankSize, this.evaporatorExhaustFluid);
        this.addElement((AbstractElement)evaporatorExhaustTank);
    }

    public void func_231023_e_() {
        if (!this.heatExchangerState.condenserIntakeFluid.equals(Objects.requireNonNull(this.condenserIntakeFluid.getRegistryName()).toString())) {
            this.condenserIntakeFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.condenserIntakeFluid));
        }
        if (!this.heatExchangerState.evaporatorIntakeFluid.equals(Objects.requireNonNull(this.evaporatorIntakeFluid.getRegistryName()).toString())) {
            this.evaporatorIntakeFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.evaporatorIntakeFluid));
        }
        if (!this.heatExchangerState.condenserExhaustFluid.equals(Objects.requireNonNull(this.condenserExhaustFluid.getRegistryName()).toString())) {
            this.condenserExhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.condenserExhaustFluid));
        }
        if (!this.heatExchangerState.evaporatorExhaustFluid.equals(Objects.requireNonNull(this.evaporatorExhaustFluid.getRegistryName()).toString())) {
            this.evaporatorExhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.heatExchangerState.evaporatorExhaustFluid));
        }
    }

    public static void renderHeatGauge(@Nonnull MatrixStack mStack, @Nonnull Symbol<HeatExchangerTerminalContainer> symbol, double heatStored, double heatCapacity) {
        if (heatStored > 0.0 && heatCapacity > 0.0) {
            int renderSize = (int)((double)symbol.height * heatStored / heatCapacity);
            symbol.blit(mStack, symbol.u + 36, symbol.v);
            symbol.blit(mStack, symbol.width, symbol.height - renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(mStack);
        symbol.tooltip = new StringTextComponent(String.format("%.1f/%.1f \u00b0C", heatStored, heatCapacity));
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.getFont().func_238421_b_(mStack, String.format("%.0f \u00b0K", this.heatExchangerState.condenserChannelTemperature), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 107), 0x404040);
        this.getFont().func_238421_b_(mStack, String.format("%.0f \u00b0K", this.heatExchangerState.evaporatorChannelTemperature), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 127), 0x404040);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)(this.heatExchangerState.condenserChannelFlowRate / 1000.0), (int)1, (String)"B/t", (boolean)true), (float)(this.getGuiLeft() + 93), (float)(this.getGuiTop() + 107), 0x404040);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)(this.heatExchangerState.evaporatorChannelFlowRate / 1000.0), (int)1, (String)"B/t", (boolean)true), (float)(this.getGuiLeft() + 93), (float)(this.getGuiTop() + 127), 0x404040);
    }
}

