/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client.deps.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.roguelogix.biggerreactors.client.deps.jei.classic.reactor.BlockModeratorCategory;
import net.roguelogix.biggerreactors.client.deps.jei.classic.reactor.FluidModeratorCategory;
import net.roguelogix.biggerreactors.client.deps.jei.classic.turbine.CoilCategory;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorTerminal;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineTerminal;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;

@JeiPlugin
public class BiggerReactorsJEIPlugin
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("biggerreactors", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CoilCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockModeratorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidModeratorCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TurbineTerminal.INSTANCE), new ResourceLocation[]{CoilCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ReactorTerminal.INSTANCE), new ResourceLocation[]{BlockModeratorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ReactorTerminal.INSTANCE), new ResourceLocation[]{FluidModeratorCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List recipes = TurbineCoilRegistry.getImmutableRegistry().entrySet().stream().map(e -> new CoilCategory.Recipe(new ItemStack((IItemProvider)((Block)e.getKey()).func_199767_j()), (TurbineCoilRegistry.CoilData)e.getValue())).collect(Collectors.toList());
        registration.addRecipes(recipes, CoilCategory.UID);
        ArrayList fluidModeratorRecipes = new ArrayList();
        ArrayList blockModeratorRecipes = new ArrayList();
        ReactorModeratorRegistry.getImmutableRegistry().forEach((block, moderatorProperties) -> {
            if (block instanceof FlowingFluidBlock) {
                FlowingFluidBlock fluidBlock = (FlowingFluidBlock)block;
                FluidStack stack = new FluidStack((Fluid)fluidBlock.getFluid(), 1000);
                fluidModeratorRecipes.add(new FluidModeratorCategory.Recipe(stack, (ReactorModeratorRegistry.ModeratorProperties)moderatorProperties));
            } else if (!(block instanceof AirBlock)) {
                ItemStack stack = new ItemStack((IItemProvider)block.func_199767_j());
                blockModeratorRecipes.add(new BlockModeratorCategory.Recipe(stack, (ReactorModeratorRegistry.ModeratorProperties)moderatorProperties));
            }
        });
        registration.addRecipes(fluidModeratorRecipes, FluidModeratorCategory.UID);
        registration.addRecipes(blockModeratorRecipes, BlockModeratorCategory.UID);
    }
}

